/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.Process;
import com.x91tec.appshelf.components.AppHook;
import com.x91tec.appshelf.components.utils.AppUtils;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;

public final class AppEnvironment {
    public static final boolean DEBUG;
    public static final String NAME;
    public static final String VERSION_NAME;
    public static final int VERSION_CODE;

    public static String getAppName(Context context) {
        PackageInfo packageInfo = AppUtils.getPackageInfo(context);
        if (packageInfo != null) {
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        return null;
    }

    public static String getVersionName(Context context) {
        PackageInfo packageInfo = AppUtils.getPackageInfo(context);
        if (packageInfo != null) {
            return packageInfo.versionName;
        }
        return null;
    }

    public static int getVersionCode(Context context) {
        PackageInfo packageInfo = AppUtils.getPackageInfo(context);
        if (packageInfo != null) {
            return packageInfo.versionCode;
        }
        return -1;
    }

    static boolean isDebug(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory() / 1024L;
    }

    public static int getDeviceUsableMemory(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return (int)(mi.availMem / 0x100000L);
    }

    public static int getNumCores() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]", pathname.getName());
                }
            });
            return files.length;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static int gc(Context context) {
        List processList;
        long i = AppEnvironment.getDeviceUsableMemory(context);
        int count = 0;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List serviceList = am.getRunningServices(100);
        if (serviceList != null) {
            for (ActivityManager.RunningServiceInfo service : serviceList) {
                if (service.pid == Process.myPid()) continue;
                try {
                    Process.killProcess((int)service.pid);
                    ++count;
                }
                catch (Exception e) {
                    e.getStackTrace();
                }
            }
        }
        if ((processList = am.getRunningAppProcesses()) != null) {
            for (ActivityManager.RunningAppProcessInfo process : processList) {
                String[] pkgList;
                if (process.importance <= 200) continue;
                for (String pkgName : pkgList = process.pkgList) {
                    try {
                        am.killBackgroundProcesses(pkgName);
                        ++count;
                    }
                    catch (Exception e) {
                        e.getStackTrace();
                    }
                }
            }
        }
        return count;
    }

    public static boolean isDalvik() {
        return "Dalvik".equals(AppEnvironment.getCurrentRuntimeValue());
    }

    public static boolean isART() {
        String currentRuntime = AppEnvironment.getCurrentRuntimeValue();
        return "ART".equals(currentRuntime) || "ART debug build".equals(currentRuntime);
    }

    public static String getCurrentRuntimeValue() {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            try {
                Method get = systemProperties.getMethod("get", String.class, String.class);
                if (get == null) {
                    return "WTF?!";
                }
                try {
                    String value = (String)get.invoke(systemProperties, "persist.sys.dalvik.vm.lib", "Dalvik");
                    if ("libdvm.so".equals(value)) {
                        return "Dalvik";
                    }
                    if ("libart.so".equals(value)) {
                        return "ART";
                    }
                    if ("libartd.so".equals(value)) {
                        return "ART debug build";
                    }
                    return value;
                }
                catch (IllegalAccessException e) {
                    return "IllegalAccessException";
                }
                catch (IllegalArgumentException e) {
                    return "IllegalArgumentException";
                }
                catch (InvocationTargetException e) {
                    return "InvocationTargetException";
                }
            }
            catch (NoSuchMethodException e) {
                return "SystemProperties.get(String key, String def) method is not found";
            }
        }
        catch (ClassNotFoundException e) {
            return "SystemProperties class is not found";
        }
    }

    static {
        Object application = AppHook.getApp();
        if (application == null) {
            DEBUG = false;
            NAME = null;
            VERSION_CODE = -1;
            VERSION_NAME = "UnSupport";
        } else {
            DEBUG = AppEnvironment.isDebug(application);
            PackageInfo packageInfo = AppUtils.getPackageInfo(application);
            if (packageInfo == null) {
                NAME = null;
                VERSION_CODE = -1;
                VERSION_NAME = "UnSupport";
            } else {
                int labelRes = packageInfo.applicationInfo.labelRes;
                NAME = application.getResources().getString(labelRes);
                VERSION_CODE = packageInfo.versionCode;
                VERSION_NAME = packageInfo.versionName;
            }
        }
    }
}

