/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components;

import android.app.Activity;
import android.app.Application;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.StrictMode;
import com.developer.bsince.log.GOL;
import com.x91tec.appshelf.components.AppEnvironment;
import com.x91tec.appshelf.components.AppWatcher;
import com.x91tec.appshelf.components.activities.ActivityLifecycleCallbacksCompat;
import com.x91tec.appshelf.components.activities.ActivityLifecycleCallbacksWrapper;
import com.x91tec.appshelf.components.activities.LifecycleCompatDispatcher;
import java.util.Iterator;
import java.util.Stack;

public final class AppHook {
    public static volatile AppHook mDelegate;
    private Application mApplication;
    private AppWatcher mWatcher;
    private int appCount;
    private final Stack<Activity> activityStack = new Stack();

    private AppHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppHook get() {
        if (mDelegate != null) return mDelegate;
        Class<AppHook> clazz = AppHook.class;
        synchronized (AppHook.class) {
            if (mDelegate != null) return mDelegate;
            mDelegate = new AppHook();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mDelegate;
        }
    }

    public void ensureApplication(Application application) {
        if (this.mApplication == null) {
            this.mApplication = application;
        }
    }

    public void setWatcher(AppWatcher watcher) {
        this.mWatcher = watcher;
    }

    public static void onCreate(Application application) {
        AppHook.get().ensureApplication(application);
        if (AppEnvironment.DEBUG) {
            StrictMode.VmPolicy.Builder builder = new StrictMode.VmPolicy.Builder().detectActivityLeaks().detectLeakedSqlLiteObjects().detectLeakedClosableObjects();
            if (Build.VERSION.SDK_INT >= 16) {
                builder.detectLeakedRegistrationObjects();
            }
            StrictMode.setVmPolicy((StrictMode.VmPolicy)builder.penaltyLog().build());
        }
    }

    public void registerActivityLifecycleCallbackUsedForProcessTool() {
        this.registerActivityLifecycleCallbacks(new ActivityLifecycleCallbacksCompat(){

            @Override
            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            @Override
            public void onPostCreate(Activity activity, Bundle savedInstanceState) {
            }

            @Override
            public void onActivityStarted(Activity activity) {
                AppHook.this.appCount++;
            }

            @Override
            public void onActivityResumed(Activity activity) {
            }

            @Override
            public void onActivityPaused(Activity activity) {
            }

            @Override
            public void onActivityStopped(Activity activity) {
                AppHook.this.appCount--;
            }

            @Override
            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            @Override
            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    public int getAppCount() {
        return this.appCount;
    }

    public static void onTerminate(Application application) {
        AppHook hook = AppHook.get();
        hook.ensureApplication(application);
        AppWatcher watcher = hook.mWatcher;
        if (watcher != null) {
            watcher.onTerminate(hook.mApplication);
        }
    }

    public static void onLowMemory(Application application) {
        AppHook hook = AppHook.get();
        hook.ensureApplication(application);
        AppWatcher watcher = hook.mWatcher;
        if (watcher != null) {
            watcher.onLowMemory(hook.mApplication);
        }
    }

    public static void onConfigurationChanged(Application application, Configuration newConfig) {
        AppHook hook = AppHook.get();
        hook.ensureApplication(application);
        AppWatcher watcher = hook.mWatcher;
        if (watcher != null) {
            watcher.onConfigurationChanged(hook.mApplication, newConfig);
        }
    }

    public static void joinActivity(Activity activity) {
        AppHook.get().activityStack.add(activity);
    }

    public Activity currentActivity() {
        if (this.activityStack.isEmpty()) {
            return null;
        }
        return this.activityStack.peek();
    }

    public void finishActivity() {
        if (this.activityStack.isEmpty()) {
            return;
        }
        Activity activity = this.activityStack.pop();
        if (activity != null && !activity.isFinishing()) {
            activity.finish();
        }
    }

    public void finishActivity(Activity activity) {
        if (activity != null) {
            if (this.activityStack.contains(activity)) {
                this.activityStack.remove(activity);
            }
            if (!activity.isFinishing()) {
                activity.finish();
            }
        }
    }

    public void popActivity(Activity activity) {
        if (activity != null && this.activityStack.contains(activity)) {
            this.activityStack.remove(activity);
        }
    }

    public void finishActivity(Class<? extends Activity> cls) {
        Iterator iterator = this.activityStack.iterator();
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            if (!activity.getClass().equals(cls)) continue;
            iterator.remove();
            if (activity.isFinishing()) continue;
            activity.finish();
        }
    }

    public void finishAllActivity() {
        while (!this.activityStack.isEmpty()) {
            Activity activity = this.activityStack.pop();
            if (activity == null || activity.isFinishing()) continue;
            activity.finish();
        }
    }

    public Activity getActivity(Class<? extends Activity> cls) {
        for (Activity activity : this.activityStack) {
            if (!activity.getClass().equals(cls)) continue;
            return activity;
        }
        return null;
    }

    public void appExit() {
        try {
            this.finishAllActivity();
            if (this.mWatcher != null && this.mWatcher.onAppExit(this.mApplication)) {
                Process.killProcess((int)Process.myPid());
            }
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkApplication() {
        if (this.mApplication == null) {
            GOL.e((String)"mApplication is null,had you called onCreate method of this class on your own Application onCreated?", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public static <App extends Application> App getApp() {
        Application app = AppHook.get().mApplication;
        if (app == null) {
            Activity activity = AppHook.get().currentActivity();
            if (activity == null) {
                return null;
            }
            app = activity.getApplication();
            AppHook.get().ensureApplication(app);
        }
        return (App)app;
    }

    public static void quitActivity(Activity activity) {
        AppHook.get().popActivity(activity);
    }

    public void registerActivityLifecycleCallbacks(ActivityLifecycleCallbacksCompat callback) {
        if (!this.checkApplication()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            AppHook.get().mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksWrapper(callback));
        } else {
            LifecycleCompatDispatcher.getDefault().registerActivityLifecycle(callback);
        }
    }

    public void unregisterActivityLifecycleCallbacks(ActivityLifecycleCallbacksCompat callback) {
        if (!this.checkApplication()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            AppHook.get().mApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksWrapper(callback));
        } else {
            LifecycleCompatDispatcher.getDefault().unregisterActivityLifecycle(callback);
        }
    }
}

