/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.x91tec.appshelf.components.AppHook;
import com.x91tec.appshelf.components.activities.ActivityFace;
import com.x91tec.appshelf.components.activities.LifecycleCompatDispatcher;
import com.x91tec.appshelf.components.fragments.ProgressDialogFragment;
import com.x91tec.appshelf.ui.swipeback.SwipeConfiguration;
import com.x91tec.appshelf.ui.swipeback.SwipePanelLayout;

public abstract class BaseAppActivity
extends AppCompatActivity
implements ActivityFace {
    private Toast toast = null;
    private boolean wasCreated;
    private boolean wasInterrupted;
    private boolean isFocus;
    private Intent currentIntent;
    private DialogFragment dialogFragment;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.wasCreated = true;
        this.currentIntent = this.getIntent();
        AppHook.joinActivity((Activity)this);
        if (Build.VERSION.SDK_INT < 14) {
            LifecycleCompatDispatcher.getDefault().onActivityCreated((Activity)this, savedInstanceState);
        }
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT < 14) {
            LifecycleCompatDispatcher.getDefault().onPostCreate((Activity)this, savedInstanceState);
        }
    }

    public void setContentView(@LayoutRes int layoutResID) {
        super.setContentView(layoutResID);
        this.initTitleBar();
        this.initComponents();
        this.initComponentsData();
    }

    public void setContentView(View view) {
        super.setContentView(view);
        this.initTitleBar();
        this.initComponents();
        this.initComponentsData();
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        this.initTitleBar();
        this.initComponents();
        this.initComponentsData();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onStart() {
        super.onStart();
        if (Build.VERSION.SDK_INT < 14) {
            LifecycleCompatDispatcher.getDefault().onActivityStarted((Activity)this);
        }
    }

    protected void onResume() {
        super.onResume();
        this.isFocus = true;
        if (Build.VERSION.SDK_INT < 14) {
            LifecycleCompatDispatcher.getDefault().onActivityResumed((Activity)this);
        }
    }

    protected void onPause() {
        super.onPause();
        this.isFocus = false;
        this.wasInterrupted = false;
        this.wasCreated = false;
        if (Build.VERSION.SDK_INT < 14) {
            LifecycleCompatDispatcher.getDefault().onActivityPaused((Activity)this);
        }
    }

    protected void onStop() {
        super.onStop();
        if (Build.VERSION.SDK_INT < 14) {
            LifecycleCompatDispatcher.getDefault().onActivityStopped((Activity)this);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        AppHook.quitActivity((Activity)this);
        if (this.toast != null) {
            this.toast.cancel();
            this.toast = null;
        }
        if (Build.VERSION.SDK_INT < 14) {
            LifecycleCompatDispatcher.getDefault().onActivityDestroyed((Activity)this);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (Build.VERSION.SDK_INT < 14) {
            LifecycleCompatDispatcher.getDefault().onActivitySaveInstanceState((Activity)this, outState);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.wasInterrupted = true;
    }

    @Override
    public void showToast(String msg) {
        if (this.toast == null) {
            this.toast = Toast.makeText((Context)this, (CharSequence)msg, (int)0);
        } else {
            this.toast.setText((CharSequence)msg);
        }
        this.toast.show();
    }

    @Override
    public void showToast(@StringRes int resId) {
        if (this.toast == null) {
            this.toast = Toast.makeText((Context)this, (int)resId, (int)0);
        } else {
            this.toast.setText(resId);
        }
        this.toast.show();
    }

    @Override
    public void showProgressDialog(String msg, boolean cancelable) {
        this.dialogFragment = ProgressDialogFragment.newInstance(msg);
        this.dialogFragment.setCancelable(cancelable);
        ((ProgressDialogFragment)this.dialogFragment).show((FragmentActivity)this);
    }

    @Override
    public void showProgressDialog(@StringRes int id2, boolean cancelable) {
        this.showProgressDialog(this.getString(id2), cancelable);
    }

    @Override
    public void dismissProgressDialog() {
        if (this.dialogFragment != null) {
            this.dialogFragment.dismiss();
            this.dialogFragment = null;
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.currentIntent = intent;
    }

    @Override
    public void supportSwipeBack(@SwipeConfiguration.SwipePosition int position, boolean isCaptureFullScreen) {
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        SwipeConfiguration configuration = new SwipeConfiguration.Builder().position(position).edgeSize(isCaptureFullScreen ? 1.0f : 0.18f).build();
        SwipePanelLayout.attachToActivity((Activity)this, configuration);
    }

    @Override
    public boolean isRestoring() {
        return this.wasInterrupted;
    }

    @Override
    public boolean isResuming() {
        return !this.wasCreated;
    }

    @Override
    public boolean isLaunching() {
        return !this.wasInterrupted && this.wasCreated;
    }

    @Override
    public boolean isActivityFont() {
        return this.isFocus;
    }

    @Override
    public Intent getCurrentIntent() {
        return this.currentIntent;
    }

    @Override
    public boolean isLandscapeMode() {
        return this.getWindowManager().getDefaultDisplay().getRotation() == 1;
    }
}

