/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.fragments;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;

public class AlertDialogFragment
extends DialogFragment {
    private static final String DIALOG_TITLE = "dialog_title";
    private static final String DIALOG_ICON = "dialog_icon";
    private static final String DIALOG_MESSAGE = "dialog_message";
    private static final String DIALOG_POSITIVE_TEXT = "positive_text";
    private static final String DIALOG_NEGATIVE_TEXT = "negative_text";
    private static final String DIALOG_FRAGMENT_TAG = "alert_dialog_fragment_tag";
    private DialogInterface.OnClickListener onDialogClickListener;

    public static AlertDialogFragment newInstance(String title, String message, String pos, String neg) {
        return AlertDialogFragment.newInstance(-1, title, message, pos, neg);
    }

    public static AlertDialogFragment newInstance(int icon, String title, String message, String pos, String neg) {
        Bundle bundle = new Bundle();
        bundle.putInt(DIALOG_ICON, icon);
        bundle.putString(DIALOG_TITLE, title);
        bundle.putString(DIALOG_MESSAGE, message);
        bundle.putString(DIALOG_POSITIVE_TEXT, pos);
        bundle.putString(DIALOG_NEGATIVE_TEXT, neg);
        AlertDialogFragment f = new AlertDialogFragment();
        f.setArguments(bundle);
        return f;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle bundle = this.getArguments();
        String title = bundle.getString(DIALOG_TITLE);
        int icon = bundle.getInt(DIALOG_ICON);
        String message = bundle.getString(DIALOG_MESSAGE);
        String positiveTex = bundle.getString(DIALOG_POSITIVE_TEXT);
        String negativeTex = bundle.getString(DIALOG_NEGATIVE_TEXT);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setTitle((CharSequence)title);
        }
        if (icon != -1) {
            builder.setIcon(icon);
        }
        if (!TextUtils.isEmpty((CharSequence)message)) {
            builder.setMessage((CharSequence)message);
        }
        if (!TextUtils.isEmpty((CharSequence)positiveTex)) {
            builder.setPositiveButton((CharSequence)positiveTex, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (AlertDialogFragment.this.onDialogClickListener != null) {
                        AlertDialogFragment.this.onDialogClickListener.onClick(dialog, -1);
                    }
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)negativeTex)) {
            builder.setNegativeButton((CharSequence)negativeTex, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (AlertDialogFragment.this.onDialogClickListener != null) {
                        AlertDialogFragment.this.onDialogClickListener.onClick(dialog, -2);
                    }
                }
            });
        }
        return builder.create();
    }

    public void show(FragmentActivity context, DialogInterface.OnClickListener clickListener) {
        this.onDialogClickListener = clickListener;
        FragmentManager fm = context.getSupportFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        Fragment prev = fm.findFragmentByTag(DIALOG_FRAGMENT_TAG);
        if (prev != null) {
            ft.remove(prev);
        }
        ft.addToBackStack(null);
        this.show(ft, DIALOG_FRAGMENT_TAG);
    }
}

