/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.fragments;

import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.x91tec.appshelf.R;

public class ProgressDialogFragment
extends DialogFragment {
    public static final String DIALOG_FRAGMENT_TAG = "dialog_fragment_tag";
    private static final String STYLE_KEY = "style";
    private static final String THEME_KEY = "theme";
    private ProgressBar progressBar;
    private TextView loadMessageTex;
    private static final String LOAD_MESSAGE = "load_message";
    private static final String LOAD_LAYOUT = "load_layout";

    public static ProgressDialogFragment newInstance(String loadMessage) {
        return ProgressDialogFragment.newInstance(loadMessage, -1);
    }

    public static ProgressDialogFragment newInstance(String loadMessage, @LayoutRes int layout2) {
        Bundle bundle = new Bundle();
        bundle.putInt(STYLE_KEY, 0);
        bundle.putInt(THEME_KEY, R.style.Bison_Progress_Dialog);
        bundle.putString(LOAD_MESSAGE, loadMessage);
        bundle.putInt(LOAD_LAYOUT, layout2);
        ProgressDialogFragment p = new ProgressDialogFragment();
        p.setArguments(bundle);
        return p;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            int style2 = bundle.getInt(STYLE_KEY);
            int theme = bundle.getInt(THEME_KEY);
            this.setStyle(style2, theme);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int layout2 = this.getArguments().getInt(LOAD_LAYOUT, -1);
        if (layout2 != -1) {
            return inflater.inflate(layout2, container, false);
        }
        View view = inflater.inflate(R.layout.dialog_progress_layout, container, false);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        this.loadMessageTex = (TextView)view.findViewById(R.id.load_message);
        String loadMessage = this.getArguments().getString(LOAD_MESSAGE);
        if (!TextUtils.isEmpty((CharSequence)loadMessage)) {
            this.loadMessageTex.setText((CharSequence)loadMessage);
        }
    }

    public void show(FragmentActivity context) {
        FragmentManager fm = context.getSupportFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        Fragment prev = fm.findFragmentByTag(DIALOG_FRAGMENT_TAG);
        if (prev != null) {
            ft.remove(prev);
        }
        ft.addToBackStack(null);
        this.show(ft, DIALOG_FRAGMENT_TAG);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }
}

