/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.intent;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import java.util.List;

public final class IntentHelper {
    private IntentHelper() {
    }

    public static boolean verifyIntentReceiveApp(Context context, Intent intent) {
        PackageManager pm = context.getPackageManager();
        ComponentName componentName = intent.resolveActivity(pm);
        return componentName != null;
    }

    public static int getIntentReceiveAppCount(Context context, Intent intent) {
        PackageManager pm = context.getPackageManager();
        return pm.queryIntentActivities(intent, 65536).size();
    }

    public static List<ResolveInfo> getIntentReceiveApps(Context context, Intent intent) {
        PackageManager pm = context.getPackageManager();
        return pm.queryIntentActivities(intent, 65536);
    }

    public static boolean existMarketApp(Context context) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.APP_MARKET");
        return IntentHelper.verifyIntentReceiveApp(context, intent);
    }

    public static boolean existBrowserApp(Context context) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setData(Uri.parse((String)"http://"));
        return IntentHelper.verifyIntentReceiveApp(context, intent);
    }

    public static boolean existTelApp(Context context) {
        Intent it = new Intent("android.intent.action.DIAL");
        return IntentHelper.verifyIntentReceiveApp(context, it);
    }

    public static boolean existSmsApp(Context context) {
        Intent it = new Intent("android.intent.action.SENDTO");
        return IntentHelper.verifyIntentReceiveApp(context, it);
    }

    public static boolean existEmailApp(Context context) {
        Intent intent = new Intent("android.intent.action.SEND");
        return IntentHelper.verifyIntentReceiveApp(context, intent);
    }
}

