/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.intent;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.CalendarContract;
import com.x91tec.appshelf.components.intent.IntentHelper;
import java.io.Serializable;
import java.util.Calendar;

public final class IntentInstanceFactory {
    public static void createAlarmInstance(Context context, String message, int hour, int minutes) {
        Intent intent = new Intent("android.intent.action.SET_ALARM").putExtra("android.intent.extra.alarm.MESSAGE", message).putExtra("android.intent.extra.alarm.HOUR", hour).putExtra("android.intent.extra.alarm.MINUTES", minutes);
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            context.startActivity(intent);
        }
    }

    public static void createTimerInstance(Context context, String message, int seconds, boolean skipUi) {
        Intent intent = new Intent("android.intent.action.SET_TIMER").putExtra("android.intent.extra.alarm.MESSAGE", message).putExtra("android.intent.extra.alarm.LENGTH", seconds).putExtra("android.intent.extra.alarm.SKIP_UI", true);
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            context.startActivity(intent);
        }
    }

    public static void createCalendarEventInstance(Context context, String title, String location, Calendar begin, Calendar end) {
        Intent intent = new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI).putExtra("title", title).putExtra("eventLocation", location).putExtra("beginTime", (Serializable)begin).putExtra("endTime", (Serializable)end);
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            context.startActivity(intent);
        }
    }

    public static void createCaptureImageInstance(Activity context, Uri mLocationForPhotos, String targetFilename, int requestCode) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)Uri.withAppendedPath((Uri)mLocationForPhotos, (String)targetFilename));
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void createCaptureVideoInstance(Activity context, Uri mLocationForPhotos, String targetFilename, int requestCode) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        intent.putExtra("output", (Parcelable)Uri.withAppendedPath((Uri)mLocationForPhotos, (String)targetFilename));
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void createCaptureVideoInstance(Activity context, Uri mLocationForPhotos, String targetFilename, int requestCode, int quality, long sizeLimit, int durationLimit) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        intent.putExtra("output", (Parcelable)Uri.withAppendedPath((Uri)mLocationForPhotos, (String)targetFilename));
        intent.putExtra("android.intent.extra.videoQuality", quality);
        intent.putExtra("android.intent.extra.sizeLimit", sizeLimit);
        intent.putExtra("android.intent.extra.durationLimit", durationLimit);
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void createContactsSelectInstance(Activity context, int requestCode) {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("vnd.android.cursor.dir/phone_v2");
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void createContactsSelectInstance(Activity context, String mimeType, int requestCode) {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType(mimeType);
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void createContactEditInstance(Context context, Uri contactUri, String editKey, String editValue) {
        Intent intent = new Intent("android.intent.action.EDIT");
        intent.setData(contactUri);
        intent.putExtra(editKey, editValue);
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            context.startActivity(intent);
        }
    }

    public static void createImagePickInstance(Activity context, int requestCode) {
        IntentInstanceFactory.createFilePickInstance(context, "image/*", requestCode);
    }

    public static void createImageOpenInstance(Activity context, int requestCode) {
        IntentInstanceFactory.createFilePickInstance(context, "image/*", requestCode);
    }

    public static void createFilePickInstance(Activity context, String mimeType, int requestCode) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType(mimeType);
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void createFileOpenInstance(Activity context, String mimeType, int requestCode) {
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.setType(mimeType);
        intent.addCategory("android.intent.category.OPENABLE");
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void createMediaPlayInstance(Context context, Uri file) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(file);
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            context.startActivity(intent);
        }
    }

    public static void createSearchWebInstance(Context context, String query) {
        Intent intent = new Intent("android.intent.action.SEARCH");
        intent.putExtra("query", query);
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            context.startActivity(intent);
        }
    }
}

