/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.intent;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import com.x91tec.appshelf.components.intent.IntentHelper;

public class IntentUtils {
    private IntentUtils() {
    }

    public static void launchMarketApp(Context context, String pck) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)("market://details?id=" + pck)));
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            context.startActivity(intent);
        }
    }

    public static void launchMarketToShowSelf(Context context) {
        IntentUtils.launchMarketApp(context, context.getPackageName());
    }

    public static void launchGoogleMarket(Context activity, String pck) {
        Intent intent = new Intent();
        intent.setPackage("com.android.vending");
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)("market://details?id=" + pck)));
        if (IntentHelper.verifyIntentReceiveApp(activity, intent)) {
            activity.startActivity(intent);
        }
    }

    public static void launchBrowserApp(Context cx, String url) {
        boolean hasBrowser = IntentHelper.existBrowserApp(cx);
        if (hasBrowser) {
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            cx.startActivity(intent);
        }
    }

    public static void launchDefaultBrowser(Context cx, String url) {
        boolean hasBrowser = IntentHelper.existBrowserApp(cx);
        if (hasBrowser) {
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.setClassName("com.android.browser", "com.android.browser.BrowserActivity");
            cx.startActivity(intent);
        }
    }

    public static void launchTelDialApp(Context context, String number) {
        if (IntentHelper.existTelApp(context)) {
            Uri uri = Uri.parse((String)("tel:" + number));
            Intent it = new Intent("android.intent.action.DIAL", uri);
            context.startActivity(it);
        }
    }

    public static void launchTelDialApp(Context context) {
        Intent intent = new Intent("android.intent.action.DIAL");
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public static void launchSmsApp(Context context, String smsBody, String tel) {
        if (IntentHelper.existSmsApp(context)) {
            Uri uri = Uri.parse((String)("smsto:" + tel));
            Intent it = new Intent("android.intent.action.SENDTO", uri);
            it.putExtra("sms_body", smsBody);
            context.startActivity(it);
        }
    }

    public static void launchSmsApp(Context context) {
        Intent intent = new Intent("android.intent.action.SENDTO");
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public static void launchEmailApp(Context context, String subject, String content, Uri attachment, String ... emails) {
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)"mailto:"));
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            intent.putExtra("android.intent.extra.EMAIL", emails);
            intent.putExtra("android.intent.extra.SUBJECT", subject);
            intent.putExtra("android.intent.extra.TEXT", content);
            if (attachment != null) {
                intent.putExtra("android.intent.extra.STREAM", (Parcelable)attachment);
            }
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public static void showSystemShareOption(Activity context, String title, String url) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", "\u5206\u4eab\uff1a" + title);
        intent.putExtra("android.intent.extra.TEXT", title + " " + url);
        context.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u9009\u62e9\u5206\u4eab"));
    }

    public static void launchCameraAppForImage(Activity context, int requestCode) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void launchCameraAppForVideo(Activity context, int requestCode) {
        Intent takeVideoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (IntentHelper.verifyIntentReceiveApp((Context)context, takeVideoIntent)) {
            context.startActivityForResult(takeVideoIntent, requestCode);
        }
    }

    public static void launchCameraAppStillImage(Activity context, int requestCode) {
        Intent intent = new Intent("android.media.action.STILL_IMAGE_CAMERA");
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void launchCameraAppStillVideo(Activity context, int requestCode) {
        Intent intent = new Intent("android.media.action.VIDEO_CAMERA");
        if (IntentHelper.verifyIntentReceiveApp((Context)context, intent)) {
            context.startActivityForResult(intent, requestCode);
        }
    }

    public static void launchContactByUri(Context context, Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        if (IntentHelper.verifyIntentReceiveApp(context, intent)) {
            context.startActivity(intent);
        }
    }
}

