/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.notifycation;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.support.v7.app.NotificationCompat;
import android.widget.RemoteViews;
import java.util.ArrayList;

public final class NotificationGenerator {
    public static NotificationCompat.Builder generateCompatBuilder(Context context, PendingIntent pendingIntent, int smallIcon, String ticker, String title, String content, boolean sound, boolean vibrate, boolean lights) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setContentIntent(pendingIntent);
        builder.setSmallIcon(smallIcon);
        builder.setTicker((CharSequence)ticker);
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)content);
        builder.setWhen(System.currentTimeMillis());
        builder.setAutoCancel(true);
        builder.setPriority(2);
        int defaults = 0;
        if (sound) {
            defaults |= 1;
        }
        if (vibrate) {
            defaults |= 2;
        }
        if (lights) {
            defaults |= 4;
        }
        builder.setDefaults(defaults);
        return builder;
    }

    public static Notification.Builder generateBuilder(Context context, PendingIntent pendingIntent, int smallIcon, String ticker, boolean sound, boolean vibrate, boolean lights) {
        Notification.Builder builder = new Notification.Builder(context);
        builder.setContentIntent(pendingIntent);
        builder.setSmallIcon(smallIcon);
        builder.setTicker((CharSequence)ticker);
        builder.setWhen(System.currentTimeMillis());
        if (Build.VERSION.SDK_INT >= 16) {
            builder.setPriority(2);
        }
        int defaults = 0;
        if (sound) {
            defaults |= 1;
        }
        if (vibrate) {
            defaults |= 2;
        }
        if (lights) {
            defaults |= 4;
        }
        builder.setDefaults(defaults);
        return builder;
    }

    public static void notifySimpleNotification(Context context, int notificationId, PendingIntent pendingIntent, int smallIcon, String ticker, String title, String content, boolean sound, boolean vibrate, boolean lights) {
        NotificationCompat.Builder builder = NotificationGenerator.generateCompatBuilder(context, pendingIntent, smallIcon, ticker, title, content, sound, vibrate, lights);
        Notification notification = builder.build();
        NotificationGenerator.sendNotification(context, notificationId, notification);
    }

    public static void notifyMailBoxNotification(Context context, int notificationId, PendingIntent pendingIntent, int smallIcon, int largeIcon, ArrayList<String> messageList, String ticker, String title, String content, boolean sound, boolean vibrate, boolean lights) {
        NotificationCompat.Builder builder = NotificationGenerator.generateCompatBuilder(context, pendingIntent, smallIcon, ticker, title, content, sound, vibrate, lights);
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeIcon);
        builder.setLargeIcon(bitmap);
        builder.setDefaults(-1);
        builder.setAutoCancel(true);
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        for (String msg : messageList) {
            inboxStyle.addLine((CharSequence)msg);
        }
        inboxStyle.setSummaryText((CharSequence)("[" + messageList.size() + "\u6761]" + title));
        builder.setStyle((NotificationCompat.Style)inboxStyle);
        Notification notification = builder.build();
        NotificationGenerator.sendNotification(context, notificationId, notification);
    }

    public static void notifyCustomUINotification(Context context, int notificationId, RemoteViews remoteViews, PendingIntent pendingIntent, int smallIcon, String ticker, boolean sound, boolean vibrate, boolean lights) {
        NotificationCompat.Builder builder = NotificationGenerator.generateCompatBuilder(context, pendingIntent, smallIcon, ticker, null, null, sound, vibrate, lights);
        Notification notification = builder.build();
        notification.contentView = remoteViews;
        NotificationGenerator.sendNotification(context, notificationId, notification);
    }

    public static void notifyMultipleLineNotification(Context context, int notificationId, PendingIntent pendingIntent, int smallIcon, String ticker, String title, String content, boolean sound, boolean vibrate, boolean lights) {
        if (Build.VERSION.SDK_INT >= 16) {
            Notification.Builder builder = NotificationGenerator.generateBuilder(context, pendingIntent, smallIcon, ticker, true, true, false);
            builder.setContentTitle((CharSequence)title);
            builder.setContentText((CharSequence)content);
            builder.setPriority(1);
            Notification notification = new Notification.BigTextStyle(builder).bigText((CharSequence)content).build();
            NotificationGenerator.sendNotification(context, notificationId, notification);
            return;
        }
        NotificationGenerator.notifySimpleNotification(context, notificationId, pendingIntent, smallIcon, ticker, title, content, sound, vibrate, lights);
    }

    public static void notifyProgressNotification(Context context, int notificationId, PendingIntent pendingIntent, int smallIcon, String ticker, String title, String content, boolean sound, boolean vibrate, boolean lights, int max, int progress) {
        NotificationCompat.Builder builder = NotificationGenerator.generateCompatBuilder(context, pendingIntent, smallIcon, ticker, title, content, sound, vibrate, lights);
        builder.setProgress(max, progress, false);
        Notification notification = builder.build();
        NotificationGenerator.sendNotification(context, notificationId, notification);
    }

    public static void notifyLargeImageNotification(Context context, int notificationId, PendingIntent pendingIntent, int smallIcon, String ticker, String title, String content, int bigPic, boolean sound, boolean vibrate, boolean lights) {
        NotificationCompat.Builder builder = NotificationGenerator.generateCompatBuilder(context, pendingIntent, smallIcon, ticker, title, content, sound, vibrate, lights);
        NotificationCompat.BigPictureStyle picStyle = new NotificationCompat.BigPictureStyle();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = true;
        options.inSampleSize = 2;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)bigPic, (BitmapFactory.Options)options);
        picStyle.bigPicture(bitmap);
        picStyle.bigLargeIcon(bitmap);
        builder.setContentText((CharSequence)content);
        builder.setStyle((NotificationCompat.Style)picStyle);
        NotificationGenerator.sendNotification(context, notificationId, builder.build());
    }

    public static void notifyDoubleButtonNotification(Context context, int notificationId, int smallIcon, int leftbtnicon, String lefttext, PendingIntent leftPendIntent, int rightbtnicon, String righttext, PendingIntent rightPendIntent, String ticker, String title, String content, boolean sound, boolean vibrate, boolean lights) {
        NotificationCompat.Builder builder = NotificationGenerator.generateCompatBuilder(context, rightPendIntent, smallIcon, ticker, title, content, sound, vibrate, lights);
        builder.addAction(leftbtnicon, (CharSequence)lefttext, leftPendIntent);
        builder.addAction(rightbtnicon, (CharSequence)righttext, rightPendIntent);
        Notification notification = builder.build();
        NotificationGenerator.sendNotification(context, notificationId, notification);
    }

    public static void notifyHeadUpNotification(Context context, int notificationId, PendingIntent pendingIntent, int smallIcon, int largeIcon, String ticker, String title, String content, int leftbtnicon, String lefttext, PendingIntent leftPendingIntent, int rightbtnicon, String righttext, PendingIntent rightPendingIntent, boolean sound, boolean vibrate, boolean lights) {
        NotificationCompat.Builder builder = NotificationGenerator.generateCompatBuilder(context, pendingIntent, smallIcon, ticker, title, content, sound, vibrate, lights);
        builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeIcon));
        if (Build.VERSION.SDK_INT >= 21) {
            builder.addAction(leftbtnicon, (CharSequence)lefttext, leftPendingIntent);
            builder.addAction(rightbtnicon, (CharSequence)righttext, rightPendingIntent);
        }
        NotificationGenerator.sendNotification(context, notificationId, builder.build());
    }

    public static void sendNotification(Context context, int notificationId, Notification notification) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(notificationId, notification);
    }

    public static void clearNotification(Context context, int id2) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (id2 > 0) {
            notificationManager.cancel(id2);
            return;
        }
        notificationManager.cancelAll();
    }
}

