/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.services;

import android.app.Activity;
import android.os.Handler;
import android.os.Message;
import com.x91tec.appshelf.components.services.Downloader;
import com.x91tec.appshelf.components.services.EmptyUpCallback;
import com.x91tec.appshelf.components.services.SystemDownloader;
import com.x91tec.appshelf.components.services.UIDetector;
import com.x91tec.appshelf.components.services.UpCallback;
import com.x91tec.appshelf.components.services.UpInteractive;
import com.x91tec.appshelf.components.services.VersionResponse;
import java.lang.ref.WeakReference;

public final class AppVersionController<T extends Activity> {
    private WeakReference<T> mContext;
    private VersionResponse response;
    private UpCallback callback;
    private UpInteractive interactive;
    private Downloader downloader;
    private UIDetector uiDetector;

    private AppVersionController(T t) {
        this.mContext = new WeakReference<T>(t);
    }

    public static <T extends Activity> AppVersionController<T> target(T t) {
        return new AppVersionController<T>(t);
    }

    public T getActivity() {
        return (T)((Activity)this.mContext.get());
    }

    public AppVersionController<T> response(VersionResponse response) {
        this.response = response;
        return this;
    }

    public void startUpVersion(UpCallback callback) {
        this.callback = callback;
        this.ensureParams();
        if (this.response.hasNewVersion()) {
            this.uiDetector.requestGrantUp((Activity)this.getActivity(), this.response, this.interactive);
        } else {
            this.uiDetector.onUnnecessaryUp((Activity)this.getActivity(), this.response);
        }
    }

    public AppVersionController<T> upInteractive(UpInteractive interactive) {
        this.interactive = interactive;
        return this;
    }

    public AppVersionController<T> downloader(Downloader downloader) {
        this.downloader = downloader;
        return this;
    }

    public AppVersionController<T> ui(UIDetector uiDetector) {
        this.uiDetector = uiDetector;
        return this;
    }

    void ensureParams() {
        if (this.response == null) {
            throw new IllegalArgumentException("VersionResponse can not be null");
        }
        if (this.uiDetector == null) {
            throw new IllegalArgumentException("UIDetector can not be null");
        }
        if (this.downloader == null) {
            this.downloader = new SystemDownloader();
        }
        if (this.callback == null) {
            this.callback = new EmptyUpCallback();
        }
        if (this.interactive == null) {
            this.interactive = new UpInteractive(){

                @Override
                public void onAllowUp(VersionResponse response) {
                    AppVersionController.this.callback.onStartUp(response);
                    AppVersionController.this.downloader.download(response, AppVersionController.this.callback);
                }

                @Override
                public void onForbidUp(VersionResponse response) {
                    AppVersionController.this.callback.onUpCancel(response);
                }
            };
        }
    }

    public void cancel(VersionResponse response, UpCallback callback) {
        if (this.downloader != null) {
            this.downloader.cancel(response, callback);
        }
    }

    public void cancel() {
        if (this.downloader != null) {
            if (this.callback == null) {
                this.callback = new EmptyUpCallback();
            }
            this.downloader.cancel(this.response, this.callback);
        }
    }

    public static class MessengerHandler
    extends Handler {
        public void handleMessage(Message msg) {
        }
    }
}

