/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.services;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.x91tec.appshelf.storage.IOUtils;
import com.x91tec.appshelf.storage.SQLiteController;

public class DownloadDatabase
extends SQLiteOpenHelper {
    public static final String DB_NAME = "myDownloads";
    public static final int DB_VERSION = 1;
    public static final String TABLE_NAME = "table_download";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_TAG_ID = "taskId";
    public static final String COLUMN_URI = "uri";
    private final SQLiteController.Table table = new SQLiteController.Table("table_download");
    private static DownloadDatabase database = null;

    private DownloadDatabase(Context context) {
        super(context, DB_NAME, null, 1);
        this.table.addColumn(new SQLiteController.Column(COLUMN_ID, 0, SQLiteController.buildAutoIncrementPrimaryKey()));
        this.table.addColumn(new SQLiteController.Column(COLUMN_TAG_ID, 0, "NOT NULL"));
        this.table.addColumn(new SQLiteController.Column(COLUMN_URI, 2, "UNIQUE"));
    }

    public void onCreate(SQLiteDatabase db) {
        SQLiteController.createTable(db, this.table);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        SQLiteController.dropTable(db, TABLE_NAME);
        this.onCreate(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadDatabase get(Context context) {
        if (database != null) return database;
        Class<DownloadDatabase> clazz = DownloadDatabase.class;
        synchronized (DownloadDatabase.class) {
            if (database != null) return database;
            database = new DownloadDatabase(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return database;
        }
    }

    public int matchTaskId(String uri) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query(true, TABLE_NAME, null, "uri = ?", new String[]{uri}, null, null, "_id desc", null);
        if (cursor != null && cursor.moveToFirst()) {
            int taskId = cursor.getInt(cursor.getColumnIndex(COLUMN_TAG_ID));
            IOUtils.closeQuietly(cursor);
            return taskId;
        }
        IOUtils.closeQuietly(cursor);
        return -1;
    }

    public synchronized long insertRecords(long taskId, String uri) {
        SQLiteDatabase db = this.getWritableDatabase();
        int matchId = this.matchTaskId(uri);
        if (matchId > 0) {
            db.delete(TABLE_NAME, "uri = ?", new String[]{uri});
        }
        ContentValues values = new ContentValues();
        values.put(COLUMN_TAG_ID, Long.valueOf(taskId));
        values.put(COLUMN_URI, uri);
        return db.insert(TABLE_NAME, null, values);
    }

    public synchronized int deleteByTaskId(long taskId) {
        SQLiteDatabase db = this.getWritableDatabase();
        return db.delete(TABLE_NAME, "taskId = ?", new String[]{String.valueOf(taskId)});
    }
}

