/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.services;

import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.developer.bsince.log.GOL;
import com.x91tec.appshelf.components.AppHook;
import com.x91tec.appshelf.components.services.DownloadDatabase;
import com.x91tec.appshelf.components.services.Downloader;
import com.x91tec.appshelf.components.services.UpCallback;
import com.x91tec.appshelf.components.services.VersionResponse;
import com.x91tec.appshelf.storage.IOUtils;
import java.io.File;

public class SystemDownloader
implements Downloader {
    private DownloadManager downloadManager;
    static final int MSG_PROGRESS = 0;

    public SystemDownloader() {
        Object app = AppHook.getApp();
        if (app == null) {
            throw new IllegalArgumentException("AppHook's application is null,were you ensureApplication?");
        }
        this.downloadManager = (DownloadManager)app.getSystemService("download");
    }

    @Override
    public void download(VersionResponse response, UpCallback callback) {
        File directory;
        DownloadDatabase database = DownloadDatabase.get(AppHook.getApp());
        long taskId = database.matchTaskId(response.linkUri);
        GOL.e((String)("matched taskId is :" + taskId), (Object[])new Object[0]);
        if (taskId >= 0L) {
            response.tag = String.valueOf(taskId);
            DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{taskId});
            Cursor cursor = this.downloadManager.query(query);
            if (cursor != null && cursor.moveToFirst()) {
                File downloadFile;
                int status = cursor.getInt(cursor.getColumnIndex("status"));
                IOUtils.closeQuietly(cursor);
                GOL.e((String)("find record in system downloads :status:" + status), (Object[])new Object[0]);
                if (status == 8 && (downloadFile = new File(response.localUri + response.fileName)).exists()) {
                    GOL.e((String)"file exists :complete", (Object[])new Object[0]);
                    callback.onCompletedUp(response);
                    return;
                }
                if (status == 2) {
                    GOL.e((String)"task running", (Object[])new Object[0]);
                    return;
                }
                if (status == 16 || status == 4) {
                    GOL.e((String)"task pause-fail", (Object[])new Object[0]);
                    this.downloadManager.remove(new long[]{taskId});
                    DownloadDatabase.get(AppHook.getApp()).deleteByTaskId(taskId);
                }
            }
        }
        if (!(directory = new File(response.localUri)).exists() || !directory.isDirectory()) {
            GOL.d((String)"directory is not existed or  not a directory ,mk!", (Object[])new Object[0]);
            boolean flag = directory.mkdirs();
            if (flag) {
                throw new IllegalArgumentException("can not create directory:" + response.localUri);
            }
        }
        DownloadManager.Request request = this.versionResponse2Request(response);
        taskId = this.downloadManager.enqueue(request);
        response.tag = String.valueOf(taskId);
        DownloadDatabase.get(AppHook.getApp()).insertRecords(taskId, response.linkUri);
        ProgressHandler mHandler = new ProgressHandler(response, callback);
        mHandler.sendEmptyMessage(0);
    }

    protected DownloadManager.Request versionResponse2Request(VersionResponse response) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)response.linkUri));
        request.setDestinationUri(Uri.fromFile((File)new File(response.localUri + response.fileName)));
        request.setTitle((CharSequence)response.title);
        request.setDescription((CharSequence)response.description);
        return request;
    }

    @Override
    public void cancel(VersionResponse response, UpCallback callback) {
        Object application = AppHook.getApp();
        assert (application != null);
        long taskId = this.matchRealTaskId((Context)application, response);
        this.downloadManager.remove(new long[]{taskId});
        DownloadDatabase.get(application).deleteByTaskId(taskId);
        callback.onUpCancel(response);
    }

    long matchRealTaskId(Context context, VersionResponse response) {
        try {
            if (TextUtils.isEmpty((CharSequence)response.tag)) {
                return DownloadDatabase.get(context).matchTaskId(response.linkUri);
            }
            return Integer.parseInt(response.tag);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public class ProgressHandler
    extends Handler {
        private UpCallback callback;
        private VersionResponse response;
        private final long taskId;

        public ProgressHandler(VersionResponse response, UpCallback callback) {
            this.response = response;
            this.callback = callback;
            Object application = AppHook.getApp();
            assert (application != null);
            this.taskId = SystemDownloader.this.matchRealTaskId((Context)application, response);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                this.progressUp(this.response, this.callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getBytesAndStatus(long downloadId) {
            int[] bytesAndStatus = new int[]{-1, -1, 0};
            DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{downloadId});
            try (Cursor c = null;){
                c = SystemDownloader.this.downloadManager.query(query);
                if (c != null && c.moveToFirst()) {
                    bytesAndStatus[0] = c.getInt(c.getColumnIndexOrThrow("bytes_so_far"));
                    bytesAndStatus[1] = c.getInt(c.getColumnIndexOrThrow("total_size"));
                    bytesAndStatus[2] = c.getInt(c.getColumnIndex("status"));
                }
            }
            return bytesAndStatus;
        }

        void progressUp(VersionResponse response, UpCallback callback) {
            if (this.taskId < 0L) {
                callback.onUpError(response);
                this.removeCallbacksAndMessages(null);
                return;
            }
            int[] datas = this.getBytesAndStatus(this.taskId);
            int status = datas[2];
            if (status == 8) {
                callback.onCompletedUp(response);
                this.removeCallbacksAndMessages(null);
            } else if (status == 16) {
                callback.onUpError(response);
                this.removeCallbacksAndMessages(null);
            } else {
                response.fileSize = datas[1];
                callback.onProgressUp(response, datas[0]);
                this.sendEmptyMessageDelayed(0, 1000L);
            }
        }
    }
}

