/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.services;

import android.content.Context;
import com.developer.bsince.log.GOL;
import com.x91tec.appshelf.R;
import com.x91tec.appshelf.components.AppEnvironment;
import com.x91tec.appshelf.converter.TextUtils;
import com.x91tec.appshelf.storage.FileUtil;
import com.x91tec.appshelf.storage.SDCardUtils;

public class VersionResponse {
    public final String linkUri;
    public final String localUri;
    public final String fileName;
    public final String tempName;
    public final String newVersionName;
    public final int newVersionCode;
    public final String versionName;
    public final int versionCode;
    public final boolean forceUpgrade;
    public final String title;
    public final String description;
    public final String releaseNote;
    public long fileSize;
    public String tag;

    public VersionResponse(Builder builder) {
        this.linkUri = builder.linkUri;
        this.localUri = builder.localUri;
        this.fileName = builder.fileName;
        this.tempName = builder.tempName;
        this.newVersionName = builder.newVersionName;
        this.newVersionCode = builder.newVersionCode;
        this.forceUpgrade = builder.forceUpgrade;
        this.title = builder.title;
        this.description = builder.description;
        this.releaseNote = builder.releaseNote;
        this.versionName = AppEnvironment.VERSION_NAME;
        this.versionCode = AppEnvironment.VERSION_CODE;
    }

    private static String getTempFileName(String fileName) {
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex != -1) {
            String tempName = fileName.substring(0, lastIndex);
            return tempName + "_temp";
        }
        return fileName + "_temp";
    }

    public String toString() {
        return String.format("linkUrl[%1$s]\nlocalUri[%2$s]\nfileName[%3$s]\ntempFileName[%4$s]\nnewVersionName[%5$s]\nnewVersionCode[%6$s]\ncurrentVersionName[%7$s]\ncurrentVersionCode[%8$d]\nforceUpdate[%9$d]\ntitle[%10$s]\ndescription[%11$s]\nreleaseNote[%12$s]\n", this.linkUri, this.localUri, this.fileName, this.tempName, this.newVersionName, this.newVersionCode, this.versionName, this.versionCode, this.forceUpgrade ? 1 : 0, this.title, this.description, this.releaseNote);
    }

    public boolean hasNewVersion() {
        return this.versionCode < this.newVersionCode;
    }

    public static class Builder {
        private String linkUri;
        private String localUri;
        private String fileName;
        private String tempName;
        private String title;
        private String description;
        private String newVersionName;
        private int newVersionCode;
        private String releaseNote;
        private boolean forceUpgrade = false;

        public Builder linkUri(String linkUri) {
            this.linkUri = linkUri;
            return this;
        }

        public Builder localUri(String localUri) {
            this.localUri = localUri;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder forceUpgrade(boolean forceUpgrade) {
            this.forceUpgrade = forceUpgrade;
            return this;
        }

        public Builder newVersionName(String newVersionName) {
            this.newVersionName = newVersionName;
            return this;
        }

        public Builder newVersionCode(int newVersionCode) {
            this.newVersionCode = newVersionCode;
            return this;
        }

        public Builder releaseNote(String releaseNote) {
            this.releaseNote = releaseNote;
            return this;
        }

        public VersionResponse build(Context mContext) {
            if (TextUtils.isEmpty(this.linkUri)) {
                throw new IllegalArgumentException("linkUri can not be null");
            }
            if (TextUtils.isEmpty(this.localUri)) {
                if (!SDCardUtils.hasExternalStoragePermission(mContext)) {
                    throw new IllegalArgumentException("localUri auto set should must have external storage permission");
                }
                this.localUri = SDCardUtils.getSDCardPath();
            }
            if (TextUtils.isEmpty(this.newVersionName) && AppEnvironment.VERSION_NAME.indexOf(46) != -1) {
                int index = AppEnvironment.VERSION_NAME.lastIndexOf(46);
                this.newVersionName = AppEnvironment.VERSION_NAME.substring(0, index + 1) + this.newVersionCode;
            }
            if (TextUtils.isEmpty(this.fileName)) {
                this.fileName = FileUtil.getFileName(this.linkUri);
            }
            StringBuilder buffer = new StringBuilder();
            String fn = FileUtil.getFileNameNoFormat(this.linkUri);
            String format = FileUtil.getFileFormat(this.fileName);
            buffer.append(fn).append("_").append(this.newVersionName).append(".").append(format);
            this.fileName = buffer.toString();
            this.tempName = VersionResponse.getTempFileName(this.fileName);
            if (TextUtils.isEmpty(this.title)) {
                this.title = AppEnvironment.NAME;
            }
            if (TextUtils.isEmpty(this.description)) {
                this.description = "app download";
            }
            if (TextUtils.isEmpty(this.releaseNote)) {
                this.releaseNote = mContext.getResources().getString(R.string.empty_releaseNote);
            }
            VersionResponse ui = new VersionResponse(this);
            GOL.d((String)ui.toString(), (Object[])new Object[0]);
            return ui;
        }
    }
}

