/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.components.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.widget.Toast;
import java.io.File;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

public class AppUtils {
    private AppUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static PackageInfo getPackageInfo(Context context) {
        PackageInfo info = null;
        try {
            info = context.getPackageManager().getPackageInfo(context.getPackageName(), 1);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace(System.err);
        }
        return info;
    }

    public static void installApk(Context context, String apkFilePath) {
        File apkFile = new File(apkFilePath);
        if (!apkFile.exists()) {
            Toast.makeText((Context)context, (CharSequence)"apk file is not exist", (int)0).show();
            return;
        }
        Uri uri = Uri.fromFile((File)apkFile);
        AppUtils.installApk(context, uri);
    }

    public static void installApk(Context context, Uri uri) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.addFlags(0x10000000);
        i.setDataAndType(uri, "application/vnd.android.package-archive");
        context.startActivity(i);
    }

    public static void uninstallApk(Context cx, String packageName) {
        Intent intent = new Intent("android.intent.action.DELETE");
        Uri packageURI = Uri.parse((String)("package:" + packageName));
        intent.setData(packageURI);
        cx.startActivity(intent);
    }

    public static String getDeviceId(Context mContext) {
        TelephonyManager tel = (TelephonyManager)mContext.getSystemService("phone");
        return tel.getDeviceId();
    }

    public static String getPhoneType() {
        return Build.MODEL;
    }

    public static Drawable getAppIconDrawable(Context ctx, String pkgName) {
        PackageManager pm = ctx.getPackageManager();
        PackageInfo pi = null;
        try {
            pi = pm.getPackageInfo(pkgName, 1);
            return pi.applicationInfo.loadIcon(pm);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Drawable getAppIconDrawable(Context ctx, PackageInfo pi) {
        PackageManager pm = ctx.getPackageManager();
        if (pi != null) {
            return pi.applicationInfo.loadIcon(pm);
        }
        return null;
    }

    public static List<PackageInfo> getAllPackageInfo(Context ctx) {
        PackageManager pm = ctx.getPackageManager();
        return pm.getInstalledPackages(0);
    }

    public static boolean isAppInstalled(Context ctx, String pkg, int versionCode) {
        PackageManager pm = ctx.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(pkg, 0);
            if (pi != null && pi.versionCode == versionCode) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAppInstalled(Context ctx, String pkg) {
        PackageManager pm = ctx.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(pkg, 0);
            if (pi != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static List<PackageInfo> getSystemPackageInfo(Context ctx) {
        PackageManager pm = ctx.getPackageManager();
        List allApps = pm.getInstalledPackages(0);
        ArrayList<PackageInfo> sysAppList = new ArrayList<PackageInfo>();
        for (PackageInfo pi : allApps) {
            if ((pi.applicationInfo.flags & 1) <= 0) continue;
            sysAppList.add(pi);
        }
        return sysAppList;
    }

    public static List<PackageInfo> getInstallPackageInfo(Context ctx) {
        PackageManager pm = ctx.getPackageManager();
        List allApps = pm.getInstalledPackages(0);
        ArrayList<PackageInfo> installAppList = new ArrayList<PackageInfo>();
        for (PackageInfo pi : allApps) {
            if ((pi.applicationInfo.flags & 1) > 0) continue;
            installAppList.add(pi);
        }
        return installAppList;
    }

    public static Drawable getAPKIconDrawable(Context ctx, String filePath) {
        PackageManager pm = ctx.getPackageManager();
        PackageInfo pkgInfo = pm.getPackageArchiveInfo(filePath, 1);
        if (pkgInfo != null) {
            ApplicationInfo appInfo = pkgInfo.applicationInfo;
            appInfo.sourceDir = filePath;
            appInfo.publicSourceDir = filePath;
            return appInfo.loadIcon(pm);
        }
        return null;
    }

    public static PackageInfo getPackageInfo(Context ctx, String pkgName) {
        PackageManager pm = ctx.getPackageManager();
        try {
            return pm.getPackageInfo(pkgName, 1);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static ApplicationInfo getApplicationInfo(Context ctx, String pkgName) {
        PackageManager pm = ctx.getPackageManager();
        try {
            return pm.getPackageInfo((String)pkgName, (int)64).applicationInfo;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static PackageInfo getAPKPackageInfo(Context ctx, String filePath) {
        PackageManager pm = ctx.getPackageManager();
        PackageInfo pi = pm.getPackageArchiveInfo(filePath, 1);
        if (pi != null) {
            pi.applicationInfo.sourceDir = filePath;
            pi.applicationInfo.publicSourceDir = filePath;
        }
        return pi;
    }

    public static String getAppName(Context ctx, PackageInfo pi) {
        return pi.applicationInfo.loadLabel(ctx.getPackageManager()).toString();
    }

    public static String getAppName(Context ctx, String pkg) {
        PackageManager pm = ctx.getPackageManager();
        try {
            ApplicationInfo ai = pm.getPackageInfo((String)pkg, (int)1).applicationInfo;
            return ai.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static String getAppSignature(Context ctx, String pkgName) {
        PackageInfo pis = null;
        try {
            pis = ctx.getPackageManager().getPackageInfo(pkgName, 64);
            return AppUtils.hexDigest(pis.signatures[0].toByteArray());
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String hexDigest(byte[] paramArrayOfByte) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest localMessageDigest = MessageDigest.getInstance("MD5");
            localMessageDigest.update(paramArrayOfByte);
            byte[] arrayOfByte = localMessageDigest.digest();
            char[] arrayOfChar = new char[32];
            int i = 0;
            int j = 0;
            while (true) {
                if (i >= 16) {
                    return new String(arrayOfChar);
                }
                byte k = arrayOfByte[i];
                arrayOfChar[j] = hexDigits[0xF & k >>> 4];
                arrayOfChar[++j] = hexDigits[k & 0xF];
                ++i;
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isAllowInstallUnknownApp(Context ctx) {
        try {
            return Settings.Secure.getInt((ContentResolver)ctx.getContentResolver(), (String)"install_non_market_apps") == 1;
        }
        catch (Exception e) {
            return false;
        }
    }
}

