/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.connectivity;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;

public class Connectivity {
    private Connectivity() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            NetworkInfo info;
            ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isGpsEnabled(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        return lm.isProviderEnabled("gps");
    }

    public static boolean isWifiEnabled(Context context) {
        ConnectivityManager mgrConn = (ConnectivityManager)context.getSystemService("connectivity");
        TelephonyManager mgrTel = (TelephonyManager)context.getSystemService("phone");
        return mgrConn.getActiveNetworkInfo() != null && mgrConn.getActiveNetworkInfo().getState() == NetworkInfo.State.CONNECTED || mgrTel.getNetworkType() == 3;
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static boolean is3G(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 0;
    }

    public static int getNetworkType(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni == null || !ni.isConnected()) {
            return -1;
        }
        return ni.getType();
    }

    public static void openNetworkSetting(Context ctx) {
        try {
            Intent intent = null;
            if (Build.VERSION.SDK_INT > 10) {
                intent = new Intent("android.settings.WIRELESS_SETTINGS");
            } else {
                intent = new Intent();
                ComponentName component = new ComponentName("com.android.settings", "com.android.settings.WirelessSettings");
                intent.setComponent(component);
                intent.setAction("android.intent.action.VIEW");
            }
            ctx.startActivity(intent);
        }
        catch (Exception e) {
            try {
                Connectivity.openNetworkSetting2((Activity)ctx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void openNetworkSetting2(Activity activity) {
        Intent intent = new Intent("/");
        ComponentName cm = new ComponentName("com.android.settings", "com.android.settings.WirelessSettings");
        intent.setComponent(cm);
        intent.setAction("android.intent.action.VIEW");
        activity.startActivityForResult(intent, 0);
    }

    public static String getMacAddress(Context mContext) {
        WifiManager wifiManager = (WifiManager)mContext.getSystemService("wifi");
        if (!wifiManager.isWifiEnabled()) {
            if (ContextCompat.checkSelfPermission((Context)mContext, (String)"android.permission.CHANGE_WIFI_STATE") == 0) {
                wifiManager.setWifiEnabled(true);
            } else {
                return "";
            }
        }
        if (ContextCompat.checkSelfPermission((Context)mContext, (String)"android.permission.ACCESS_WIFI_STATE") == 0) {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            return wifiInfo.getMacAddress();
        }
        return "";
    }

    public static String getPhoneIp(Context mContext) {
        WifiManager wifiManager = (WifiManager)mContext.getSystemService("wifi");
        if (!wifiManager.isWifiEnabled()) {
            if (ContextCompat.checkSelfPermission((Context)mContext, (String)"android.permission.CHANGE_WIFI_STATE") == 0) {
                wifiManager.setWifiEnabled(true);
            } else {
                return "";
            }
        }
        if (ContextCompat.checkSelfPermission((Context)mContext, (String)"android.permission.ACCESS_WIFI_STATE") == 0) {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            int ipAddress = wifiInfo.getIpAddress();
            String ip = Connectivity.intToIp(ipAddress);
            return ip;
        }
        return "";
    }

    private static String intToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }

    public static String getNetTypeString(Context mContext) {
        ConnectivityManager mConnectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
        NetworkInfo info = mConnectivityManager.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            if (info.getType() == 1) {
                return "WIFI";
            }
            int type = info.getSubtype();
            switch (type) {
                case 7: {
                    return "1xRTT";
                }
                case 4: {
                    return "CDMA";
                }
                case 2: {
                    return "EDGE";
                }
                case 5: {
                    return "EVDO_0";
                }
                case 6: {
                    return "EVDO_A";
                }
                case 1: {
                    return "GPRS";
                }
                case 8: {
                    return "HSDPA";
                }
                case 10: {
                    return "HSPA";
                }
                case 9: {
                    return "HSUPA";
                }
                case 11: {
                    return "IDEN";
                }
                case 3: {
                    return "UMTS";
                }
                case 15: {
                    return "HSPAP";
                }
                case 14: {
                    return "EHRPD";
                }
                case 13: {
                    return "LTE";
                }
                case 12: {
                    return "EVDO_B";
                }
                case 0: {
                    return "UNKNOWN";
                }
            }
            return "UNKNOWN";
        }
        return "NONE";
    }
}

