/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.converter;

import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;

public class TextUtils {
    public static boolean isEmpty(String input) {
        if (input == null || "".equals(input)) {
            return true;
        }
        if (input.equals("null")) {
            return true;
        }
        if (input.replaceAll(" ", "").equals("{}")) {
            return true;
        }
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return false;
        }
        return true;
    }

    public static Spanned tintText(String text, String colorContent, int color) {
        if (!TextUtils.isEmpty(colorContent) && text.contains(colorContent)) {
            int start = text.indexOf(colorContent);
            int end = start + colorContent.length();
            return TextUtils.tintText(text, start, end, color);
        }
        return new SpannableString((CharSequence)text);
    }

    public static Spanned tintText(String text, int start, int end, int color) {
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)text);
        ForegroundColorSpan colorSpan = new ForegroundColorSpan(color);
        builder.setSpan((Object)colorSpan, start, end, 33);
        return builder;
    }

    public static Boolean isChinese(String str) {
        Boolean isChinese = true;
        String chinese = "[\u0391-\uffe5]";
        if (!TextUtils.isEmpty(str)) {
            for (int i = 0; i < str.length(); ++i) {
                String temp = str.substring(i, i + 1);
                if (temp.matches(chinese)) continue;
                isChinese = false;
            }
        }
        return isChinese;
    }

    public static Boolean isContainChinese(String str) {
        Boolean isChinese = false;
        String chinese = "[\u0391-\uffe5]";
        if (!TextUtils.isEmpty(str)) {
            for (int i = 0; i < str.length(); ++i) {
                String temp = str.substring(i, i + 1);
                if (!temp.matches(chinese)) continue;
                isChinese = true;
            }
        }
        return isChinese;
    }

    public static boolean isDecimal(Object o) {
        double n = 0.0;
        try {
            n = Double.parseDouble(o.toString().trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return n > 0.0;
    }

    public static Boolean isNumber(String str) {
        Boolean isNumber = false;
        String expr = "^[0-9]+$";
        if (str.matches(expr)) {
            isNumber = true;
        }
        return isNumber;
    }

    public static Boolean isNumberLetter(String str) {
        Boolean isNoLetter = false;
        String expr = "^[A-Za-z0-9]+$";
        if (str.matches(expr)) {
            isNoLetter = true;
        }
        return isNoLetter;
    }

    public static int strLength(String str) {
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        if (!TextUtils.isEmpty(str)) {
            for (int i = 0; i < str.length(); ++i) {
                String temp = str.substring(i, i + 1);
                if (temp.matches(chinese)) {
                    valueLength += 2;
                    continue;
                }
                ++valueLength;
            }
        }
        return valueLength;
    }

    public static int subStringLength(String str, int maxL) {
        int currentIndex = 0;
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < str.length(); ++i) {
            String temp = str.substring(i, i + 1);
            valueLength = temp.matches(chinese) ? (valueLength += 2) : ++valueLength;
            if (valueLength < maxL) continue;
            currentIndex = i;
            break;
        }
        return currentIndex;
    }
}

