/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.graphic;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.developer.bsince.log.GOL;
import com.x91tec.appshelf.components.utils.DisplayUtils;
import com.x91tec.appshelf.storage.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapByFile(File file) {
        FileInputStream fis = null;
        Bitmap bitmap = null;
        try {
            fis = new FileInputStream(file);
            bitmap = BitmapFactory.decodeStream((InputStream)fis);
        }
        catch (FileNotFoundException | OutOfMemoryError e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
        }
        IOUtils.closeQuietly(fis);
        return bitmap;
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, int w, int h) {
        Bitmap newbmp = null;
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            float scaleWidht = (float)w / (float)width;
            float scaleHeight = (float)h / (float)height;
            matrix.postScale(scaleWidht, scaleHeight);
            newbmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return newbmp;
    }

    public static Bitmap scaleBitmap(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int newWidth = 200;
        int newHeight = 200;
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static Bitmap reDrawBitMap(Activity context, Bitmap bitmap) {
        int[] sp = DisplayUtils.getScreenInfo((Context)context);
        int rWidth = sp[0];
        int width = bitmap.getWidth();
        float zoomScale = width >= rWidth ? (float)rWidth / (float)width : 1.0f;
        Matrix matrix = new Matrix();
        matrix.postScale(zoomScale, zoomScale);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, width, height);
        drawable.draw(canvas);
        return bitmap;
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float roundPx) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap createReflectionImageWithOrigin(Bitmap bitmap) {
        int reflectionGap = 4;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.preScale(1.0f, -1.0f);
        Bitmap reflectionImage = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(height / 2), (int)width, (int)(height / 2), (Matrix)matrix, (boolean)false);
        Bitmap bitmapWithReflection = Bitmap.createBitmap((int)width, (int)(height + height / 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmapWithReflection);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        Paint deafalutPaint = new Paint();
        canvas.drawRect(0.0f, (float)height, (float)width, (float)(height + 4), deafalutPaint);
        canvas.drawBitmap(reflectionImage, 0.0f, (float)(height + 4), null);
        Paint paint = new Paint();
        LinearGradient shader = new LinearGradient(0.0f, (float)bitmap.getHeight(), 0.0f, (float)(bitmapWithReflection.getHeight() + 4), 0x70FFFFFF, 0xFFFFFF, Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawRect(0.0f, (float)height, (float)width, (float)(bitmapWithReflection.getHeight() + 4), paint);
        return bitmapWithReflection;
    }

    public static Drawable bitmapToDrawable(Bitmap bitmap) {
        BitmapDrawable drawable = new BitmapDrawable(bitmap);
        return drawable;
    }

    public static Bitmap BoxBlurFilterB(Bitmap bmp, int[] params) {
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        bmp.getPixels(inPixels, 0, width, 0, 0, width, height);
        for (int i = 0; i < params[2]; ++i) {
            ImageUtil.blur(inPixels, outPixels, width, height, params[0]);
            ImageUtil.blur(outPixels, inPixels, height, width, params[1]);
        }
        ImageUtil.blurFractional(inPixels, outPixels, width, height, params[0]);
        ImageUtil.blurFractional(outPixels, inPixels, height, width, params[1]);
        bitmap.setPixels(inPixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    private static void blur(int[] in, int[] out, int width, int height, float radius) {
        int widthMinus1 = width - 1;
        int r = (int)radius;
        int tableSize = 2 * r + 1;
        int[] divide = new int[256 * tableSize];
        for (int i = 0; i < 256 * tableSize; ++i) {
            divide[i] = i / tableSize;
        }
        int inIndex = 0;
        for (int y = 0; y < height; ++y) {
            int outIndex = y;
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int i = -r; i <= r; ++i) {
                int rgb = in[inIndex + ImageUtil.clamp(i, 0, width - 1)];
                ta += rgb >> 24 & 0xFF;
                tr += rgb >> 16 & 0xFF;
                tg += rgb >> 8 & 0xFF;
                tb += rgb & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int i2;
                out[outIndex] = divide[ta] << 24 | divide[tr] << 16 | divide[tg] << 8 | divide[tb];
                int i1 = x + r + 1;
                if (i1 > widthMinus1) {
                    i1 = widthMinus1;
                }
                if ((i2 = x - r) < 0) {
                    i2 = 0;
                }
                int rgb1 = in[inIndex + i1];
                int rgb2 = in[inIndex + i2];
                ta += (rgb1 >> 24 & 0xFF) - (rgb2 >> 24 & 0xFF);
                tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
                tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
                tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
                outIndex += height;
            }
            inIndex += width;
        }
    }

    private static int clamp(int x, int a, int b) {
        return x < a ? a : (x > b ? b : x);
    }

    private static void blurFractional(int[] in, int[] out, int width, int height, float radius) {
        radius -= (float)((int)radius);
        float f = 1.0f / (1.0f + 2.0f * radius);
        int inIndex = 0;
        for (int y = 0; y < height; ++y) {
            int outIndex = y;
            out[outIndex] = in[0];
            outIndex += height;
            for (int x = 1; x < width - 1; ++x) {
                int i = inIndex + x;
                int rgb1 = in[i - 1];
                int rgb2 = in[i];
                int rgb3 = in[i + 1];
                int a1 = rgb1 >> 24 & 0xFF;
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int a2 = rgb2 >> 24 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                int a3 = rgb3 >> 24 & 0xFF;
                int r3 = rgb3 >> 16 & 0xFF;
                int g3 = rgb3 >> 8 & 0xFF;
                int b3 = rgb3 & 0xFF;
                a1 = a2 + (int)((float)(a1 + a3) * radius);
                r1 = r2 + (int)((float)(r1 + r3) * radius);
                g1 = g2 + (int)((float)(g1 + g3) * radius);
                b1 = b2 + (int)((float)(b1 + b3) * radius);
                a1 = (int)((float)a1 * f);
                r1 = (int)((float)r1 * f);
                g1 = (int)((float)g1 * f);
                b1 = (int)((float)b1 * f);
                out[outIndex] = a1 << 24 | r1 << 16 | g1 << 8 | b1;
                outIndex += height;
            }
            out[outIndex] = in[width - 1];
            inIndex += width;
        }
    }

    public static Bitmap drawImageWithShadow(Bitmap originalBitmap) {
        BlurMaskFilter blurFilter = new BlurMaskFilter(2.0f, BlurMaskFilter.Blur.OUTER);
        Paint shadowPaint = new Paint();
        Paint boardpaint = new Paint();
        boardpaint.setColor(-1);
        boardpaint.setStrokeWidth(2.0f);
        boardpaint.setStyle(Paint.Style.STROKE);
        shadowPaint.setMaskFilter((MaskFilter)blurFilter);
        int[] offsetXY = new int[2];
        int width = originalBitmap.getWidth();
        int height = originalBitmap.getHeight();
        Bitmap shadowBitmap = originalBitmap.extractAlpha(shadowPaint, offsetXY);
        Bitmap shadowImage32 = shadowBitmap.copy(Bitmap.Config.ARGB_8888, true);
        Canvas c = new Canvas(shadowImage32);
        c.drawBitmap(originalBitmap, 2.0f, 2.0f, null);
        c.drawRect(2.0f, 2.0f, (float)(width + 2), (float)(height + 2), boardpaint);
        return shadowImage32;
    }

    public static Bitmap getCircleBitmap(Bitmap bitmap) {
        float dst_bottom;
        float dst_right;
        float dst_top;
        float dst_left;
        float right;
        float left;
        float bottom;
        float top;
        float roundPx;
        int height;
        int width = bitmap.getWidth();
        if (width <= (height = bitmap.getHeight())) {
            roundPx = width / 2;
            top = 0.0f;
            bottom = width;
            left = 0.0f;
            right = width;
            height = width;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = width;
            dst_bottom = width;
        } else {
            float clip;
            roundPx = height / 2;
            left = clip = (float)((width - height) / 2);
            right = (float)width - clip;
            top = 0.0f;
            bottom = height;
            width = height;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = height;
            dst_bottom = height;
        }
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect src = new Rect((int)left, (int)top, (int)right, (int)bottom);
        Rect dst = new Rect((int)dst_left, (int)dst_top, (int)dst_right, (int)dst_bottom);
        RectF rectF = new RectF(dst);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, src, dst, paint);
        return output;
    }

    public static byte[] Bitmap2Bytes(Bitmap bm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap getBitmapFormSrc(String src) {
        Bitmap bit = null;
        try {
            bit = BitmapFactory.decodeStream((InputStream)ImageUtil.class.getClassLoader().getResourceAsStream(src));
        }
        catch (Exception e) {
            GOL.d((String)"\u83b7\u53d6\u56fe\u7247\u5f02\u5e38", (Object[])new Object[0]);
        }
        return bit;
    }

    public static Drawable getDrawableForSrc(String src) {
        return Drawable.createFromStream((InputStream)ImageUtil.class.getClassLoader().getResourceAsStream(src), null);
    }

    public static Bitmap getBitmapFromAssets(Context context, String fileName) {
        Bitmap bit = null;
        try {
            bit = BitmapFactory.decodeStream((InputStream)context.getAssets().open(fileName));
        }
        catch (Exception e) {
            GOL.d((String)"\u83b7\u53d6\u56fe\u7247\u5f02\u5e38", (Object[])new Object[0]);
        }
        return bit;
    }
}

