/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.hardware;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class GravitySensorManager
implements SensorEventListener {
    private int SPEED_THRESHOLD = 3000;
    private int INTERVAL_TIME = 100;
    private Sensor sensor;
    private SensorManager mSensorManager;
    private OnShakedListener onShakedListener;
    private Context mContext;
    private float lastx;
    private float lasty;
    private float lastz;
    private long lastupdatetime;

    public GravitySensorManager(Activity context) {
        this(context, 2000, 100);
    }

    public GravitySensorManager(Activity activity, int speed, int time) {
        this.mContext = activity;
        this.SPEED_THRESHOLD = speed;
        this.INTERVAL_TIME = time;
        this.init();
    }

    private void init() {
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        if (this.mSensorManager != null) {
            this.sensor = this.mSensorManager.getDefaultSensor(1);
        }
        if (this.sensor != null) {
            this.mSensorManager.registerListener((SensorEventListener)this, this.sensor, 1);
        }
    }

    public void stop() {
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    public void setonShakedListener(OnShakedListener onShakedListener) {
        this.onShakedListener = onShakedListener;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        long currenttime = System.currentTimeMillis();
        long timeInterval = currenttime - this.lastupdatetime;
        if (timeInterval < (long)this.INTERVAL_TIME) {
            return;
        }
        this.lastupdatetime = currenttime;
        float curx = event.values[0];
        float cury = event.values[1];
        float curz = event.values[2];
        float deltaX = curx - this.lastx;
        float deltaY = cury - this.lasty;
        float deltaZ = curz - this.lastz;
        this.lastx = curx;
        this.lasty = cury;
        this.lastz = curz;
        double speed = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) / (double)timeInterval * 10000.0;
        if (speed >= (double)this.SPEED_THRESHOLD) {
            this.onShakedListener.shake();
        }
    }

    public static interface OnShakedListener {
        public void shake();
    }
}

