/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.process;

import android.accessibilityservice.AccessibilityService;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;

public class DetectService
extends AccessibilityService {
    private static String mForegroundPackageName;
    private static DetectService mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DetectService getInstance() {
        if (mInstance != null) return mInstance;
        Class<DetectService> clazz = DetectService.class;
        synchronized (DetectService.class) {
            if (mInstance != null) return mInstance;
            mInstance = new DetectService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void onAccessibilityEvent(AccessibilityEvent event) {
        if (event.getEventType() == 32) {
            mForegroundPackageName = event.getPackageName().toString();
        }
    }

    public void onInterrupt() {
    }

    public String getForegroundPackage() {
        return mForegroundPackageName;
    }

    public static boolean isAccessibilitySettingsOn(Context context) {
        String services;
        int accessibilityEnabled = 0;
        try {
            accessibilityEnabled = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"accessibility_enabled");
        }
        catch (Settings.SettingNotFoundException e) {
            Log.d((String)"wenming", (String)e.getMessage());
        }
        if (accessibilityEnabled == 1 && (services = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services")) != null) {
            return services.toLowerCase().contains(context.getPackageName().toLowerCase());
        }
        return false;
    }

    static {
        mInstance = null;
    }
}

