/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.process;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.x91tec.appshelf.R;
import com.x91tec.appshelf.components.AppHook;
import com.x91tec.appshelf.process.AndroidAppProcess;
import com.x91tec.appshelf.process.DetectService;
import com.x91tec.appshelf.process.ProcessManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ProcessTool {
    public static final int BKGMETHOD_GETRUNNING_TASK = 0;
    public static final int BKGMETHOD_GETRUNNING_PROCESS = 1;
    public static final int BKGMETHOD_GETAPPLICATION_VALUE = 2;
    public static final int BKGMETHOD_GETUSAGESTATS = 3;
    public static final int BKGMETHOD_GETACCESSIBILITYSERVICE = 4;
    public static final int BKGMETHOD_GETLINUXPROCESS = 5;

    public static boolean isForeground(Context context, int methodID, String packageName) {
        switch (methodID) {
            case 0: {
                return ProcessTool.getRunningTask(context, packageName);
            }
            case 1: {
                return ProcessTool.getRunningAppProcesses(context, packageName);
            }
            case 2: {
                return ProcessTool.getApplicationValue();
            }
            case 3: {
                return ProcessTool.queryUsageStats(context, packageName);
            }
            case 4: {
                return ProcessTool.getFromAccessibilityService(context, packageName);
            }
            case 5: {
                return ProcessTool.getLinuxCoreInfo(context, packageName);
            }
        }
        return false;
    }

    public static boolean getRunningTask(Context context, String packageName) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ComponentName cn = ((ActivityManager.RunningTaskInfo)am.getRunningTasks((int)1).get((int)0)).topActivity;
        return !TextUtils.isEmpty((CharSequence)packageName) && packageName.equals(cn.getPackageName());
    }

    public static boolean getRunningAppProcesses(Context context, String packageName) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    public static boolean getApplicationValue() {
        return AppHook.get().getAppCount() > 0;
    }

    @TargetApi(value=21)
    public static boolean queryUsageStats(Context context, String packageName) {
        class RecentUseComparator
        implements Comparator<UsageStats> {
            RecentUseComparator() {
            }

            @Override
            public int compare(UsageStats lhs, UsageStats rhs) {
                return lhs.getLastTimeUsed() > rhs.getLastTimeUsed() ? -1 : (lhs.getLastTimeUsed() == rhs.getLastTimeUsed() ? 0 : 1);
            }
        }
        RecentUseComparator mRecentComp = new RecentUseComparator();
        long ts = System.currentTimeMillis();
        UsageStatsManager mUsageStatsManager = (UsageStatsManager)context.getSystemService("usagestats");
        List usageStats = mUsageStatsManager.queryUsageStats(4, ts - 10000L, ts);
        if (usageStats == null || usageStats.size() == 0) {
            if (!ProcessTool.HavaPermissionForTest(context)) {
                Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
                intent.setFlags(0x10000000);
                context.startActivity(intent);
                Toast.makeText((Context)context, (CharSequence)"\u6743\u9650\u4e0d\u591f\n\u8bf7\u6253\u5f00\u624b\u673a\u8bbe\u7f6e\uff0c\u70b9\u51fb\u5b89\u5168-\u9ad8\u7ea7\uff0c\u5728\u6709\u6743\u67e5\u770b\u4f7f\u7528\u60c5\u51b5\u7684\u5e94\u7528\u4e2d\uff0c\u4e3a\u8fd9\u4e2aApp\u6253\u4e0a\u52fe", (int)0).show();
            }
            return false;
        }
        Collections.sort(usageStats, mRecentComp);
        String currentTopPackage = ((UsageStats)usageStats.get(0)).getPackageName();
        return currentTopPackage.equals(packageName);
    }

    @TargetApi(value=19)
    private static boolean HavaPermissionForTest(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
            int mode = appOpsManager.checkOpNoThrow("android:get_usage_stats", applicationInfo.uid, applicationInfo.packageName);
            return mode == 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return true;
        }
    }

    public static boolean getFromAccessibilityService(Context context, String packageName) {
        if (DetectService.isAccessibilitySettingsOn(context)) {
            DetectService detectService = DetectService.getInstance();
            String foreground = detectService.getForegroundPackage();
            Log.d((String)"wenming", (String)("**\u65b9\u6cd5\u4e94** \u5f53\u524d\u7a97\u53e3\u7126\u70b9\u5bf9\u5e94\u7684\u5305\u540d\u4e3a\uff1a =" + foreground));
            return packageName.equals(foreground);
        }
        Intent intent = new Intent("android.settings.ACCESSIBILITY_SETTINGS");
        intent.setFlags(0x10000000);
        context.startActivity(intent);
        Toast.makeText((Context)context, (int)R.string.accessbiliityNo, (int)0).show();
        return false;
    }

    public static boolean getLinuxCoreInfo(Context context, String packageName) {
        List<AndroidAppProcess> processes = ProcessManager.getRunningForegroundApps(context);
        for (AndroidAppProcess appProcess : processes) {
            if (!appProcess.getPackageName().equals(packageName) || !appProcess.foreground) continue;
            return true;
        }
        return false;
    }
}

