/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.resources;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.x91tec.appshelf.storage.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class AssetDatabaseOpenHelper {
    private Context context;
    private String databaseName;

    public AssetDatabaseOpenHelper(Context context, String databaseName) {
        this.context = context;
        this.databaseName = databaseName;
    }

    public synchronized SQLiteDatabase getWritableDatabase() {
        File dbFile = this.context.getDatabasePath(this.databaseName);
        if (dbFile != null && !dbFile.exists()) {
            try {
                this.copyDatabase(dbFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating source database", e);
            }
        }
        assert (dbFile != null);
        return SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)0);
    }

    public synchronized SQLiteDatabase getReadableDatabase() {
        File dbFile = this.context.getDatabasePath(this.databaseName);
        if (dbFile != null && !dbFile.exists()) {
            try {
                this.copyDatabase(dbFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating source database", e);
            }
        }
        assert (dbFile != null);
        return SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)1);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    private void copyDatabase(File dbFile) throws IOException {
        InputStream stream = this.context.getAssets().open(this.databaseName);
        FileUtil.writeFile(dbFile, stream);
        stream.close();
    }
}

