/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.security;

import java.util.Arrays;

public class Base64 {
    private static final char[] CA;
    private static final int[] IA;
    private static final byte[] encodingTable;
    private static final byte[] decodingTable;

    public static byte[] encode(byte[] data) {
        int modulus = data.length % 3;
        byte[] bytes = modulus == 0 ? new byte[4 * data.length / 3] : new byte[4 * (data.length / 3 + 1)];
        int dataLength = data.length - modulus;
        int i = 0;
        int j = 0;
        while (i < dataLength) {
            int a1 = data[i] & 0xFF;
            int a2 = data[i + 1] & 0xFF;
            int a3 = data[i + 2] & 0xFF;
            bytes[j] = encodingTable[a1 >>> 2 & 0x3F];
            bytes[j + 1] = encodingTable[(a1 << 4 | a2 >>> 4) & 0x3F];
            bytes[j + 2] = encodingTable[(a2 << 2 | a3 >>> 6) & 0x3F];
            bytes[j + 3] = encodingTable[a3 & 0x3F];
            i += 3;
            j += 4;
        }
        switch (modulus) {
            case 0: {
                break;
            }
            case 1: {
                int d1 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = d1 << 4 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = 61;
                bytes[bytes.length - 1] = 61;
                break;
            }
            case 2: {
                int d1 = data[data.length - 2] & 0xFF;
                int d2 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = (d1 << 4 | d2 >>> 4) & 0x3F;
                int b3 = d2 << 2 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = encodingTable[b3];
                bytes[bytes.length - 1] = 61;
            }
        }
        return bytes;
    }

    public static byte[] decode(byte[] data) {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        byte[] bytes = (data = Base64.discardNonBase64Bytes(data))[data.length - 2] == 61 ? new byte[(data.length / 4 - 1) * 3 + 1] : (data[data.length - 1] == 61 ? new byte[(data.length / 4 - 1) * 3 + 2] : new byte[data.length / 4 * 3]);
        int i = 0;
        int j = 0;
        while (i < data.length - 4) {
            b1 = decodingTable[data[i]];
            b2 = decodingTable[data[i + 1]];
            b3 = decodingTable[data[i + 2]];
            b4 = decodingTable[data[i + 3]];
            bytes[j] = (byte)(b1 << 2 | b2 >> 4);
            bytes[j + 1] = (byte)(b2 << 4 | b3 >> 2);
            bytes[j + 2] = (byte)(b3 << 6 | b4);
            i += 4;
            j += 3;
        }
        if (data[data.length - 2] == 61) {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            bytes[bytes.length - 1] = (byte)(b1 << 2 | b2 >> 4);
        } else if (data[data.length - 1] == 61) {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            b3 = decodingTable[data[data.length - 2]];
            bytes[bytes.length - 2] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 1] = (byte)(b2 << 4 | b3 >> 2);
        } else {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            b3 = decodingTable[data[data.length - 2]];
            b4 = decodingTable[data[data.length - 1]];
            bytes[bytes.length - 3] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 2] = (byte)(b2 << 4 | b3 >> 2);
            bytes[bytes.length - 1] = (byte)(b3 << 6 | b4);
        }
        return bytes;
    }

    public static byte[] decode(String data) {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        byte[] bytes = (data = Base64.discardNonBase64Chars(data)).charAt(data.length() - 2) == '=' ? new byte[(data.length() / 4 - 1) * 3 + 1] : (data.charAt(data.length() - 1) == '=' ? new byte[(data.length() / 4 - 1) * 3 + 2] : new byte[data.length() / 4 * 3]);
        int i = 0;
        int j = 0;
        while (i < data.length() - 4) {
            b1 = decodingTable[data.charAt(i)];
            b2 = decodingTable[data.charAt(i + 1)];
            b3 = decodingTable[data.charAt(i + 2)];
            b4 = decodingTable[data.charAt(i + 3)];
            bytes[j] = (byte)(b1 << 2 | b2 >> 4);
            bytes[j + 1] = (byte)(b2 << 4 | b3 >> 2);
            bytes[j + 2] = (byte)(b3 << 6 | b4);
            i += 4;
            j += 3;
        }
        if (data.charAt(data.length() - 2) == '=') {
            b1 = decodingTable[data.charAt(data.length() - 4)];
            b2 = decodingTable[data.charAt(data.length() - 3)];
            bytes[bytes.length - 1] = (byte)(b1 << 2 | b2 >> 4);
        } else if (data.charAt(data.length() - 1) == '=') {
            b1 = decodingTable[data.charAt(data.length() - 4)];
            b2 = decodingTable[data.charAt(data.length() - 3)];
            b3 = decodingTable[data.charAt(data.length() - 2)];
            bytes[bytes.length - 2] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 1] = (byte)(b2 << 4 | b3 >> 2);
        } else {
            b1 = decodingTable[data.charAt(data.length() - 4)];
            b2 = decodingTable[data.charAt(data.length() - 3)];
            b3 = decodingTable[data.charAt(data.length() - 2)];
            b4 = decodingTable[data.charAt(data.length() - 1)];
            bytes[bytes.length - 3] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 2] = (byte)(b2 << 4 | b3 >> 2);
            bytes[bytes.length - 1] = (byte)(b3 << 6 | b4);
        }
        return bytes;
    }

    private static byte[] discardNonBase64Bytes(byte[] data) {
        byte[] temp = new byte[data.length];
        int bytesCopied = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Base64.isValidBase64Byte(data[i])) continue;
            temp[bytesCopied++] = data[i];
        }
        byte[] newData = new byte[bytesCopied];
        System.arraycopy(temp, 0, newData, 0, bytesCopied);
        return newData;
    }

    private static String discardNonBase64Chars(String data) {
        StringBuffer sb = new StringBuffer();
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            if (!Base64.isValidBase64Byte((byte)data.charAt(i))) continue;
            sb.append(data.charAt(i));
        }
        return sb.toString();
    }

    private static boolean isValidBase64Byte(byte b) {
        if (b == 61) {
            return true;
        }
        if (b < 0 || b >= 128) {
            return false;
        }
        return decodingTable[b] != -1;
    }

    public static final String encodeToString(byte[] sArr, boolean lineSep) {
        return new String(Base64.encodeToChar(sArr, lineSep));
    }

    public static final char[] encodeToChar(byte[] sArr, boolean lineSep) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (lineSep ? (cCnt - 1) / 76 << 1 : 0);
        char[] dArr = new char[dLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = CA[i >>> 18 & 0x3F];
            dArr[d++] = CA[i >>> 12 & 0x3F];
            dArr[d++] = CA[i >>> 6 & 0x3F];
            dArr[d++] = CA[i & 0x3F];
            if (!lineSep || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = CA[i >> 12];
            dArr[dLen - 3] = CA[i >>> 6 & 0x3F];
            dArr[dLen - 2] = left == 2 ? CA[i & 0x3F] : 61;
            dArr[dLen - 1] = 61;
        }
        return dArr;
    }

    static {
        int i;
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i = 0; i < iS; ++i) {
            Base64.IA[Base64.CA[i]] = i;
        }
        Base64.IA[61] = 0;
        encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        decodingTable = new byte[128];
        for (i = 0; i < 128; ++i) {
            Base64.decodingTable[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64.decodingTable[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.decodingTable[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            Base64.decodingTable[i] = (byte)(i - 48 + 52);
        }
        Base64.decodingTable[43] = 62;
        Base64.decodingTable[47] = 63;
    }
}

