/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.storage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import com.developer.bsince.log.GOL;
import com.x91tec.appshelf.converter.TextUtils;
import com.x91tec.appshelf.storage.IOUtils;
import com.x91tec.appshelf.storage.SDCardUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

public class FileUtil {
    public static void write(Context context, String fileName, String content) {
        if (content == null) {
            content = "";
        }
        try {
            FileOutputStream fos = context.openFileOutput(fileName, 0);
            fos.write(content.getBytes());
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String read(Context context, String fileName) {
        try {
            FileInputStream in = context.openFileInput(fileName);
            return FileUtil.readInStream(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String readInStream(FileInputStream inStream) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[512];
            int length = -1;
            while ((length = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, length);
            }
            outStream.close();
            inStream.close();
            return outStream.toString();
        }
        catch (IOException e) {
            GOL.i((String)e.toString(), (Object[])new Object[0]);
            return null;
        }
    }

    public static File createFile(String folderPath, String fileName) {
        File destDir = new File(folderPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        return new File(folderPath, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(byte[] buffer, String folder, String fileName) {
        boolean result;
        boolean writeSucc = false;
        boolean sdCardExist = SDCardUtils.sdCardIsAvailable();
        String folderPath = "";
        if (!sdCardExist) {
            return false;
        }
        folderPath = Environment.getExternalStorageDirectory() + File.separator + folder + File.separator;
        File fileDir = new File(folderPath);
        if (!fileDir.exists() && !(result = fileDir.mkdirs())) {
            return false;
        }
        File file = new File(folderPath + fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(buffer);
            writeSucc = true;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(out);
        }
        IOUtils.closeQuietly(out);
        return writeSucc;
    }

    public static boolean writeFile(File file, InputStream stream) {
        return FileUtil.writeFile(file, stream, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeFile(File file, InputStream stream, boolean append) {
        boolean bl;
        FileOutputStream o = null;
        try {
            FileUtil.makeDirs(file.getAbsolutePath());
            o = new FileOutputStream(file, append);
            byte[] data = new byte[1024];
            int length = -1;
            while ((length = stream.read(data)) != -1) {
                ((OutputStream)o).write(data, 0, length);
            }
            o.flush();
            bl = true;
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException("FileNotFoundException occurred. ", e);
                catch (IOException e2) {
                    throw new RuntimeException("IOException occurred. ", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(o);
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(o);
        IOUtils.closeQuietly(stream);
        return bl;
    }

    public static boolean makeDirs(String filePath) {
        String folderName = FileUtil.getFolderName(filePath);
        if (TextUtils.isEmpty(folderName)) {
            return false;
        }
        File folder = new File(folderName);
        return folder.exists() && folder.isDirectory() || folder.mkdirs();
    }

    public static String getFolderName(String filePath) {
        if (TextUtils.isEmpty(filePath)) {
            return filePath;
        }
        int filePosi = filePath.lastIndexOf(File.separator);
        return filePosi == -1 ? "" : filePath.substring(0, filePosi);
    }

    public static String getFileName(String filePath) {
        if (TextUtils.isEmpty(filePath)) {
            return "unknown";
        }
        int lastIndex = filePath.lastIndexOf(File.separator);
        if (lastIndex != -1) {
            String fileName = filePath.substring(lastIndex + 1);
            if (fileName.isEmpty()) {
                return "unknown";
            }
            return fileName;
        }
        return filePath;
    }

    public static String getFileNameNoFormat(String filePath) {
        if (TextUtils.isEmpty(filePath)) {
            return "";
        }
        int point = filePath.lastIndexOf(46);
        return filePath.substring(filePath.lastIndexOf(File.separator) + 1, point);
    }

    public static String getFileFormat(String fileName) {
        if (TextUtils.isEmpty(fileName)) {
            return "";
        }
        int point = fileName.lastIndexOf(46);
        return fileName.substring(point + 1);
    }

    public static long getFileSize(String filePath) {
        long size = 0L;
        File file = new File(filePath);
        if (file != null && file.exists()) {
            size = file.length();
        }
        return size;
    }

    public static String getFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        DecimalFormat df = new DecimalFormat("##.##");
        float temp = (float)size / 1024.0f;
        if (temp >= 1024.0f) {
            return df.format(temp / 1024.0f) + "M";
        }
        return df.format(temp) + "K";
    }

    public static String formatFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "KB" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static long getDirSize(File dir) {
        File[] files;
        if (dir == null) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return 0L;
        }
        long dirSize = 0L;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                dirSize += file.length();
                continue;
            }
            if (!file.isDirectory()) continue;
            dirSize += file.length();
            dirSize += FileUtil.getDirSize(file);
        }
        return dirSize;
    }

    public long getFileList(File dir) {
        long count = 0L;
        File[] files = dir.listFiles();
        count = files.length;
        for (File file : files) {
            if (!file.isDirectory()) continue;
            count += this.getFileList(file);
            --count;
        }
        return count;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String getTempFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SS");
        String fileName = format.format(new Timestamp(System.currentTimeMillis()));
        return fileName;
    }

    public static byte[] toBytes(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            out.write(ch);
        }
        byte[] buffer = out.toByteArray();
        out.close();
        return buffer;
    }

    public static boolean checkFileExists(String name) {
        boolean status;
        if (!name.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = new File(path.toString() + name);
            status = newPath.exists();
        } else {
            status = false;
        }
        return status;
    }

    public static boolean checkFilePathExists(String path) {
        return new File(path).exists();
    }

    public static boolean createDirectory(String directoryName) {
        boolean status;
        if (!directoryName.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = new File(path.toString() + directoryName);
            status = newPath.mkdir();
            status = true;
        } else {
            status = false;
        }
        return status;
    }

    public static boolean deleteDirectory(String fileName) {
        boolean status;
        SecurityManager checker = new SecurityManager();
        if (!fileName.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = new File(path.toString() + fileName);
            checker.checkDelete(newPath.toString());
            if (newPath.isDirectory()) {
                String[] listfile = newPath.list();
                try {
                    for (int i = 0; i < listfile.length; ++i) {
                        File deletedFile = new File(newPath.toString() + "/" + listfile[i].toString());
                        deletedFile.delete();
                    }
                    newPath.delete();
                    GOL.i((String)("DirectoryManager deleteDirectory" + fileName), (Object[])new Object[0]);
                    status = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    status = false;
                }
            } else {
                status = false;
            }
        } else {
            status = false;
        }
        return status;
    }

    public static boolean deleteFile(String fileName) {
        boolean status;
        SecurityManager checker = new SecurityManager();
        if (!fileName.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = new File(path.toString() + fileName);
            checker.checkDelete(newPath.toString());
            if (newPath.isFile()) {
                try {
                    GOL.i((String)("DirectoryManager deleteFile" + fileName), (Object[])new Object[0]);
                    newPath.delete();
                    status = true;
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                    status = false;
                }
            } else {
                status = false;
            }
        } else {
            status = false;
        }
        return status;
    }

    public static int deleteBlankPath(String path) {
        File f = new File(path);
        if (!f.canWrite()) {
            return 1;
        }
        if (f.list() != null && f.list().length > 0) {
            return 2;
        }
        if (f.delete()) {
            return 0;
        }
        return 3;
    }

    public static boolean reNamePath(String oldName, String newName) {
        File f = new File(oldName);
        return f.renameTo(new File(newName));
    }

    public static boolean deleteFileWithPath(String filePath) {
        SecurityManager checker = new SecurityManager();
        File f = new File(filePath);
        checker.checkDelete(filePath);
        if (f.isFile()) {
            GOL.i((String)("DirectoryManager deleteFile" + filePath), (Object[])new Object[0]);
            f.delete();
            return true;
        }
        return false;
    }
}

