/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.storage;

import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import com.developer.bsince.log.GOL;
import com.x91tec.appshelf.components.AppHook;
import java.util.Map;
import java.util.Set;

public final class PreferenceData {
    private static final String DEFAULT_FILE_NAME = "preference_data";
    private static String configFileName = "preference_data";
    private static PreferenceData mInstance = null;
    private final String FILE_NAME = TextUtils.isEmpty((CharSequence)configFileName) ? "preference_data" : configFileName;
    private final SharedPreferences preferences;

    private PreferenceData() {
        Object app = AppHook.getApp();
        if (app == null) {
            Activity activity = AppHook.get().currentActivity();
            if (activity == null) {
                throw new UnsupportedOperationException("UnSupport operation of get application");
            }
            app = activity.getApplication();
        }
        this.preferences = app.getSharedPreferences(this.FILE_NAME, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PreferenceData getInstance() {
        if (mInstance != null) return mInstance;
        Class<PreferenceData> clazz = PreferenceData.class;
        synchronized (PreferenceData.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PreferenceData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public static void configFileName(String fileName) {
        configFileName = fileName;
        GOL.d((String)"you should call this method before init", (Object[])new Object[0]);
    }

    public <T> void save(String key, T value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(key, String.valueOf(value));
        SharedPreferencesCompat.commit(editor);
    }

    public <T> T take(String key, T defaultValue) {
        String s = this.preferences.getString(key, String.valueOf(defaultValue));
        if (defaultValue instanceof String) {
            return (T)s;
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(s);
        }
        if (defaultValue instanceof Boolean) {
            return (T)Boolean.valueOf(s);
        }
        if (defaultValue instanceof Float) {
            return (T)Float.valueOf(s);
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(s);
        }
        return null;
    }

    public void save(String key, Set<String> set) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putStringSet(key, set);
        SharedPreferencesCompat.commit(editor);
    }

    public Set<String> take(String key, Set<String> defaultValue) {
        return this.preferences.getStringSet(key, defaultValue);
    }

    public void remove(String key) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.remove(key);
        SharedPreferencesCompat.commit(editor);
    }

    public void clear() {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.clear();
        SharedPreferencesCompat.commit(editor);
    }

    public boolean contains(String key) {
        return this.preferences.contains(key);
    }

    public Map<String, ?> getAll() {
        return this.preferences.getAll();
    }

    private static class PreferenceDefault
    implements PreferenceController {
        private PreferenceDefault() {
        }

        @Override
        public void commit(SharedPreferences.Editor editor) {
            editor.commit();
        }
    }

    private static class PreferenceGingerBread
    implements PreferenceController {
        private PreferenceGingerBread() {
        }

        @Override
        public void commit(SharedPreferences.Editor editor) {
            editor.apply();
        }
    }

    private static class SharedPreferencesCompat {
        private static final PreferenceController controller = Build.VERSION.SDK_INT >= 9 ? new PreferenceGingerBread() : new PreferenceDefault();

        private SharedPreferencesCompat() {
        }

        public static void commit(SharedPreferences.Editor editor) {
            controller.commit(editor);
        }
    }

    static interface PreferenceController {
        public void commit(SharedPreferences.Editor var1);
    }
}

