/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.storage;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import java.io.File;

public class SDCardUtils {
    private SDCardUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean hasExternalStoragePermission(Context context) {
        int perm = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        return perm == 0;
    }

    public static boolean sdCardIsAvailable() {
        String status = Environment.getExternalStorageState();
        return status.equals("mounted");
    }

    public static boolean enoughSpaceOnSdCard(long updateSize) {
        String status = Environment.getExternalStorageState();
        if (!status.equals("mounted")) {
            return false;
        }
        return updateSize < SDCardUtils.getRealSizeOnSdcard(Environment.getExternalStorageDirectory().getAbsolutePath());
    }

    public static long getRealSizeOnSdcard(String filePath) {
        File path = new File(filePath);
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    public static boolean enoughSpaceOnPhone(long updateSize) {
        return SDCardUtils.getRealSizeOnPhone() > updateSize;
    }

    public static long getRealSizeOnPhone() {
        if (SDCardUtils.sdCardIsAvailable()) {
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long availableBlocks = stat.getAvailableBlocks();
            long realSize = blockSize * availableBlocks;
            return realSize;
        }
        return 0L;
    }

    public static String getSDCardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator;
    }

    public static String getRootDirectoryPath() {
        return Environment.getRootDirectory().getAbsolutePath();
    }
}

