/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.storage;

import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class SQLiteController {
    public static final int TYPE_NULL = -1;
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_REAL = 1;
    public static final int TYPE_TEXT = 2;
    public static final int TYPE_BLOB = 3;
    private static final String SYMBOL_SPACE = " ";
    private static final String SYMBOL_COMMA = ",";
    private static final String SYMBOL_LEFT_BRACKET = "(";
    private static final String SYMBOL_RIGHT_BRACKET = ")";
    public static final String CONSTRAINT_UNIQUE = "UNIQUE";
    public static final String CONSTRAINT_NOT_NULL = "NOT NULL";
    public static final String CONSTRAINT_PRIMARY_KEY = "PRIMARY KEY";
    public static final String CONSTRAINT_AUTOINCREMENT = "AUTOINCREMENT";
    static final String CONSTRAINT_FOREIGN_KEY = "FOREIGN KEY";
    static final String CONSTRAINT_CHECK = "CHECK";
    static final String CONSTRAINT_DEFAULT = "DEFAULT";

    public static void createTable(SQLiteDatabase db, Table table) {
        db.execSQL(table.toSQLiteString());
    }

    public static void dropTable(SQLiteDatabase db, String tableName) {
        db.execSQL("DROP TABLE IF EXISTS " + tableName);
    }

    public static String SQL_PART_CREATE_TABLE_START(String tableName) {
        return "CREATE TABLE " + tableName + SYMBOL_SPACE + SYMBOL_LEFT_BRACKET;
    }

    static String columnType2String(@ColumnType int columnType) {
        switch (columnType) {
            case 0: {
                return "INTEGER";
            }
            case 1: {
                return "REAL";
            }
            case 2: {
                return "TEXT";
            }
            case 3: {
                return "BLOB";
            }
        }
        return "NULL";
    }

    public static String buildForeignKeyConstraint(String columnName, String foreignTableName, String foreignColumnName) {
        return "FOREIGN KEY(" + columnName + SYMBOL_RIGHT_BRACKET + SYMBOL_SPACE + " REFERENCES " + foreignTableName + SYMBOL_LEFT_BRACKET + foreignColumnName + SYMBOL_RIGHT_BRACKET;
    }

    public static String buildCheckConstraint(String condition) {
        return "CHECK(" + condition + SYMBOL_RIGHT_BRACKET;
    }

    public static String buildBoolConstraint(String columnName) {
        return SQLiteController.buildCheckConstraint(columnName + "= 0 or " + columnName + " = 1");
    }

    public static String buildDefaultConstraint(String value) {
        return "DEFAULT " + value;
    }

    public static String buildAutoIncrementPrimaryKey() {
        return "PRIMARY KEY AUTOINCREMENT";
    }

    public static class Column {
        final String columnName;
        @ColumnType
        final int columnType;
        final String constraint;

        public Column(String columnName, @ColumnType int columnType, String constraint) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.constraint = constraint;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.columnName);
            builder.append(SQLiteController.SYMBOL_SPACE);
            builder.append(SQLiteController.columnType2String(this.columnType));
            builder.append(SQLiteController.SYMBOL_SPACE);
            if (!TextUtils.isEmpty((CharSequence)this.constraint)) {
                builder.append(this.constraint);
            }
            return builder.toString();
        }
    }

    public static class Table {
        final String tableName;
        final List<Column> columns = new ArrayList<Column>();
        List<String> extraConstraints;

        public Table(String tableName) {
            this.tableName = tableName;
        }

        public void addColumn(Column column) {
            this.columns.add(column);
        }

        public void addColumn(String columnName, @ColumnType int columnType, String constraint) {
            Column column = new Column(columnName, columnType, constraint);
            this.addColumn(column);
        }

        public void addExtraConstraint(String constraint) {
            if (this.extraConstraints == null) {
                this.extraConstraints = new ArrayList<String>();
            }
            this.extraConstraints.add(constraint);
        }

        public String toSQLiteString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(SQLiteController.SQL_PART_CREATE_TABLE_START(this.tableName));
            int size = this.columns.size();
            int totalSize = this.calculateNum();
            int tempCount = 0;
            for (Column column : this.columns) {
                buffer.append(column.toString());
                buffer.append(++tempCount == totalSize ? SQLiteController.SYMBOL_RIGHT_BRACKET : SQLiteController.SYMBOL_COMMA);
            }
            if (size < totalSize) {
                for (String constraint : this.extraConstraints) {
                    buffer.append(this.extraConstraints);
                    buffer.append(++tempCount == totalSize ? SQLiteController.SYMBOL_RIGHT_BRACKET : SQLiteController.SYMBOL_COMMA);
                }
            }
            return buffer.toString();
        }

        boolean hasExtraConstraints() {
            return this.extraConstraints != null && !this.extraConstraints.isEmpty();
        }

        public int calculateNum() {
            int extraSize = this.hasExtraConstraints() ? this.extraConstraints.size() : 0;
            return extraSize + this.columns.size();
        }
    }

    public static @interface ColumnType {
    }
}

