/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int BUFF_SIZE = 0x100000;
    private static boolean stopZipFlag;

    public static boolean isStopZipFlag() {
        return stopZipFlag;
    }

    public static void setStopZipFlag(boolean stopZipFlag) {
        ZipUtil.stopZipFlag = stopZipFlag;
    }

    public static void zipFiles(Collection<File> resFileList, File zipFile, ZipListener zipListener) {
        ZipOutputStream zipout = null;
        try {
            zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
            for (File resFile : resFileList) {
                if (stopZipFlag) break;
                ZipUtil.zipFile(resFile, zipout, "", zipListener);
            }
            zipout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipFiles(Collection<File> resFileList, File zipFile, String comment, ZipListener zipListener) {
        ZipOutputStream zipout = null;
        try {
            zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
            for (File resFile : resFileList) {
                ZipUtil.zipFile(resFile, zipout, "", zipListener);
            }
            zipout.setComment(comment);
            zipout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void upZipFile(File zipFile, String folderPath) {
        File desDir = new File(folderPath);
        if (!desDir.exists()) {
            desDir.mkdirs();
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int realLength;
                ZipEntry entry = entries.nextElement();
                InputStream in = zf.getInputStream(entry);
                String str = folderPath + File.separator + entry.getName();
                File desFile = new File(str = new String(str.getBytes("8859_1"), "GB2312"));
                if (!desFile.exists()) {
                    File fileParentDir = desFile.getParentFile();
                    if (!fileParentDir.exists()) {
                        fileParentDir.mkdirs();
                    }
                    desFile.createNewFile();
                }
                FileOutputStream out = new FileOutputStream(desFile);
                byte[] buffer = new byte[0x100000];
                while ((realLength = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, realLength);
                }
                in.close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<File> upZipSelectedFile(File zipFile, String folderPath, String nameContains) {
        ArrayList<File> fileList = new ArrayList<File>();
        File desDir = new File(folderPath);
        if (!desDir.exists()) {
            desDir.mkdir();
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int realLength;
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().contains(nameContains)) continue;
                InputStream in = zf.getInputStream(entry);
                String str = folderPath + File.separator + entry.getName();
                File desFile = new File(str = new String(str.getBytes("8859_1"), "GB2312"));
                if (!desFile.exists()) {
                    File fileParentDir = desFile.getParentFile();
                    if (!fileParentDir.exists()) {
                        fileParentDir.mkdirs();
                    }
                    desFile.createNewFile();
                }
                FileOutputStream out = new FileOutputStream(desFile);
                byte[] buffer = new byte[0x100000];
                while ((realLength = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, realLength);
                }
                in.close();
                ((OutputStream)out).close();
                fileList.add(desFile);
            }
            return fileList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<String> getEntriesNames(File zipFile) {
        ArrayList<String> entryNames = new ArrayList<String>();
        Enumeration<?> entries = null;
        try {
            entries = ZipUtil.getEntriesEnumeration(zipFile);
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                entryNames.add(new String(ZipUtil.getEntryName(entry).getBytes("GB2312"), "8859_1"));
            }
            return entryNames;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Enumeration<?> getEntriesEnumeration(File zipFile) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(zipFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zf.entries();
    }

    public static String getEntryComment(ZipEntry entry) {
        try {
            return new String(entry.getComment().getBytes("GB2312"), "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getEntryName(ZipEntry entry) {
        try {
            return new String(entry.getName().getBytes("GB2312"), "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void zipFile(File resFile, ZipOutputStream zipout, String rootpath, ZipListener zipListener) {
        try {
            rootpath = rootpath + (rootpath.trim().length() == 0 ? "" : File.separator) + resFile.getName();
            rootpath = new String(rootpath.getBytes("8859_1"), "GB2312");
            if (resFile.isDirectory()) {
                File[] fileList = resFile.listFiles();
                int length = fileList.length;
                zipListener.zipProgress((int)(1.0f / (float)(length + 1) * 100.0f));
                for (int i = 0; i < length && !stopZipFlag; ++i) {
                    File file = fileList[i];
                    ZipUtil.zipFile(file, zipout, rootpath, zipListener);
                    zipListener.zipProgress((int)((float)(i + 2) / (float)(length + 1) * 100.0f));
                }
            } else {
                int realLength;
                byte[] buffer = new byte[0x100000];
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(resFile), 0x100000);
                zipout.putNextEntry(new ZipEntry(rootpath));
                while ((realLength = in.read(buffer)) != -1 && !stopZipFlag) {
                    zipout.write(buffer, 0, realLength);
                }
                in.close();
                zipout.flush();
                zipout.closeEntry();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface ZipListener {
        public void zipProgress(int var1);
    }
}

