/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.storage.data;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.math.BigDecimal;

public class AppDataManager {
    public static void cleanInternalCache(Context context) {
        AppDataManager.deleteFilesByDirectory(context.getCacheDir());
    }

    public static void cleanDatabases(Context context) {
        AppDataManager.deleteFilesByDirectory(new File(context.getFilesDir().getPath() + context.getPackageName() + "/databases"));
    }

    public static void cleanSharedPreference(Context context) {
        AppDataManager.deleteFilesByDirectory(new File(context.getFilesDir().getPath() + context.getPackageName() + "/shared_prefs"));
    }

    public static void cleanDatabaseByName(Context context, String dbName) {
        context.deleteDatabase(dbName);
    }

    public static void cleanFiles(Context context) {
        AppDataManager.deleteFilesByDirectory(context.getFilesDir());
    }

    public static void cleanExternalCache(Context context) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            AppDataManager.deleteFilesByDirectory(context.getExternalCacheDir());
        }
    }

    public static void cleanCustomCache(String filePath) {
        AppDataManager.deleteFilesByDirectory(new File(filePath));
    }

    public static void cleanApplicationData(Context context, String ... filePath) {
        AppDataManager.cleanInternalCache(context);
        AppDataManager.cleanExternalCache(context);
        AppDataManager.cleanDatabases(context);
        AppDataManager.cleanSharedPreference(context);
        AppDataManager.cleanFiles(context);
        for (String fp : filePath) {
            AppDataManager.cleanCustomCache(fp);
        }
    }

    private static void deleteFilesByDirectory(File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            for (File item : directory.listFiles()) {
                item.delete();
            }
        }
    }

    public static long getFolderSize(File file) throws Exception {
        long size = 0L;
        try {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    size += AppDataManager.getFolderSize(fileList[i]);
                    continue;
                }
                size += fileList[i].length();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static String getCacheSize(File file) throws Exception {
        return AppDataManager.getFormatSize(AppDataManager.getFolderSize(file));
    }

    public static String getFormatSize(double size) {
        double kiloByte = size / 1024.0;
        if (kiloByte < 1.0) {
            return size + "Byte";
        }
        double megaByte = kiloByte / 1024.0;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(kiloByte));
            return result1.setScale(2, 4).toPlainString() + "KB";
        }
        double gigaByte = megaByte / 1024.0;
        if (gigaByte < 1.0) {
            BigDecimal result2 = new BigDecimal(Double.toString(megaByte));
            return result2.setScale(2, 4).toPlainString() + "MB";
        }
        double teraBytes = gigaByte / 1024.0;
        if (teraBytes < 1.0) {
            BigDecimal result3 = new BigDecimal(Double.toString(gigaByte));
            return result3.setScale(2, 4).toPlainString() + "GB";
        }
        BigDecimal result4 = new BigDecimal(teraBytes);
        return result4.setScale(2, 4).toPlainString() + "TB";
    }
}

