/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.ui;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ScrollView;

public class BounceScrollView
extends ScrollView {
    private boolean isCalled;
    private Callback mCallback;
    private View mView;
    private Rect mRect = new Rect();
    private int y;
    private boolean isFirst = true;

    public BounceScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        if (this.getChildCount() > 0) {
            this.mView = this.getChildAt(0);
        }
        super.onFinishInflate();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mView != null) {
            this.commonOnTouch(ev);
        }
        return super.onTouchEvent(ev);
    }

    private void commonOnTouch(MotionEvent ev) {
        int action = ev.getAction();
        int cy = (int)ev.getY();
        switch (action) {
            case 0: {
                break;
            }
            case 2: {
                int dy = cy - this.y;
                if (this.isFirst) {
                    dy = 0;
                    this.isFirst = false;
                }
                this.y = cy;
                if (!this.isNeedMove()) break;
                if (this.mRect.isEmpty()) {
                    this.mRect.set(this.mView.getLeft(), this.mView.getTop(), this.mView.getRight(), this.mView.getBottom());
                }
                this.mView.layout(this.mView.getLeft(), this.mView.getTop() + 2 * dy / 3, this.mView.getRight(), this.mView.getBottom() + 2 * dy / 3);
                if (!this.shouldCallBack(dy) || this.mCallback == null || this.isCalled) break;
                this.isCalled = true;
                this.resetPosition();
                this.mCallback.callback();
                break;
            }
            case 1: {
                if (this.mRect.isEmpty()) break;
                this.resetPosition();
            }
        }
    }

    private boolean shouldCallBack(int dy) {
        return dy > 0 && this.mView.getTop() > this.getHeight() / 2;
    }

    private void resetPosition() {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, (float)this.mView.getTop(), (float)this.mRect.top);
        animation.setDuration(200L);
        animation.setFillAfter(true);
        this.mView.startAnimation((Animation)animation);
        this.mView.layout(this.mRect.left, this.mRect.top, this.mRect.right, this.mRect.bottom);
        this.mRect.setEmpty();
        this.isFirst = true;
        this.isCalled = false;
    }

    public boolean isNeedMove() {
        int offset = this.mView.getMeasuredHeight() - this.getHeight();
        int scrollY = this.getScrollY();
        return scrollY == 0 || scrollY == offset;
    }

    public void setCallBack(Callback callback) {
        this.mCallback = callback;
    }

    static interface Callback {
        public void callback();
    }
}

