/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.x91tec.appshelf.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ListAdapter<VH extends ViewHolder, T>
extends BaseAdapter {
    private Context context;
    private LayoutInflater mInflater;
    private final List<T> mList = new ArrayList<T>();

    public ListAdapter(Context context) {
        this(context, (List)null);
    }

    public ListAdapter(Context context, T[] mList) {
        this(context, Arrays.asList(mList));
    }

    public ListAdapter(Context context, List<T> mList) {
        this.context = context;
        this.mInflater = LayoutInflater.from((Context)context);
        if (mList != null) {
            this.mList.addAll(mList);
        }
    }

    public int getCount() {
        return this.mList.size();
    }

    public T getItem(int position) {
        return this.mList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = this.onCreateViewHolder(this.mInflater, parent);
            convertView = holder.itemView;
            convertView.setTag(R.id.item_view_tag_id, (Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag(R.id.item_view_tag_id);
        }
        holder.setPosition(position);
        this.onBindViewHolder(holder, position);
        return holder.itemView;
    }

    protected abstract VH onCreateViewHolder(LayoutInflater var1, ViewGroup var2);

    protected abstract void onBindViewHolder(VH var1, int var2);

    public Context getContext() {
        return this.context;
    }

    public List<T> getListData() {
        return this.mList;
    }

    public void notifyDataSetChanged(boolean keepOld, List<T> newData) {
        if (!keepOld) {
            this.mList.clear();
        }
        if (newData != null) {
            this.mList.addAll(newData);
        }
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged(boolean keepOld, T ... newData) {
        if (!keepOld) {
            this.mList.clear();
        }
        if (newData != null) {
            this.mList.addAll(Arrays.asList(newData));
        }
        this.notifyDataSetChanged();
    }

    public void clearListData() {
        this.mList.clear();
    }

    public static class ViewHolder {
        public final View itemView;
        private int position;

        public ViewHolder(View itemView) {
            this.itemView = itemView;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }
}

