/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.ui.flowlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import com.x91tec.appshelf.R;
import com.x91tec.appshelf.ui.flowlayout.LayoutConfiguration;
import com.x91tec.appshelf.ui.flowlayout.LineDefinition;
import java.util.ArrayList;
import java.util.List;

public class FlowLayout
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int LAYOUT_DIRECTION_LTR = 0;
    public static final int LAYOUT_DIRECTION_RTL = 1;
    private final LayoutConfiguration config;
    List<LineDefinition> lines = new ArrayList<LineDefinition>();

    public FlowLayout(Context context) {
        super(context);
        this.config = new LayoutConfiguration(context, null);
    }

    public FlowLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.config = new LayoutConfiguration(context, attributeSet);
    }

    public FlowLayout(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
        this.config = new LayoutConfiguration(context, attributeSet);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingRight() - this.getPaddingLeft();
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingTop() - this.getPaddingBottom();
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int controlMaxLength = this.config.getOrientation() == 0 ? sizeWidth : sizeHeight;
        int controlMaxThickness = this.config.getOrientation() == 0 ? sizeHeight : sizeWidth;
        int modeLength = this.config.getOrientation() == 0 ? modeWidth : modeHeight;
        int modeThickness = this.config.getOrientation() == 0 ? modeHeight : modeWidth;
        this.lines.clear();
        LineDefinition currentLine = new LineDefinition(controlMaxLength, this.config);
        this.lines.add(currentLine);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            boolean newLine;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.measure(FlowLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)lp.width), FlowLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)lp.height));
            lp.clearCalculatedFields(this.config.getOrientation());
            if (this.config.getOrientation() == 0) {
                lp.setLength(child.getMeasuredWidth());
                lp.setThickness(child.getMeasuredHeight());
            } else {
                lp.setLength(child.getMeasuredHeight());
                lp.setThickness(child.getMeasuredWidth());
            }
            boolean bl = newLine = lp.newLine || modeLength != 0 && !currentLine.canFit(child);
            if (newLine) {
                currentLine = new LineDefinition(controlMaxLength, this.config);
                if (this.config.getOrientation() == 1 && this.config.getLayoutDirection() == 1) {
                    this.lines.add(0, currentLine);
                } else {
                    this.lines.add(currentLine);
                }
            }
            if (this.config.getOrientation() == 0 && this.config.getLayoutDirection() == 1) {
                currentLine.addView(0, child);
                continue;
            }
            currentLine.addView(child);
        }
        this.calculateLinesAndChildPosition(this.lines);
        int contentLength = 0;
        int linesCount = this.lines.size();
        for (int i = 0; i < linesCount; ++i) {
            LineDefinition l = this.lines.get(i);
            contentLength = Math.max(contentLength, l.getLineLength());
        }
        int contentThickness = currentLine.getLineStartThickness() + currentLine.getLineThickness();
        int realControlLength = this.findSize(modeLength, controlMaxLength, contentLength);
        int realControlThickness = this.findSize(modeHeight, controlMaxThickness, contentThickness);
        this.applyGravityToLines(this.lines, realControlLength, realControlThickness);
        for (int i = 0; i < linesCount; ++i) {
            LineDefinition line = this.lines.get(i);
            this.applyGravityToLine(line);
            this.applyPositionsToViews(line);
        }
        int totalControlWidth = this.getPaddingLeft() + this.getPaddingRight();
        int totalControlHeight = this.getPaddingBottom() + this.getPaddingTop();
        if (this.config.getOrientation() == 0) {
            totalControlWidth += contentLength;
            totalControlHeight += contentThickness;
        } else {
            totalControlWidth += contentThickness;
            totalControlHeight += contentLength;
        }
        this.setMeasuredDimension(FlowLayout.resolveSize((int)totalControlWidth, (int)widthMeasureSpec), FlowLayout.resolveSize((int)totalControlHeight, (int)heightMeasureSpec));
    }

    private int findSize(int modeSize, int controlMaxSize, int contentSize) {
        int realControlLength;
        switch (modeSize) {
            case 0: {
                realControlLength = contentSize;
                break;
            }
            case -2147483648: {
                realControlLength = Math.min(contentSize, controlMaxSize);
                break;
            }
            case 0x40000000: {
                realControlLength = controlMaxSize;
                break;
            }
            default: {
                realControlLength = contentSize;
            }
        }
        return realControlLength;
    }

    private void calculateLinesAndChildPosition(List<LineDefinition> lines) {
        int prevLinesThickness = 0;
        int linesCount = lines.size();
        for (int i = 0; i < linesCount; ++i) {
            LineDefinition line = lines.get(i);
            line.addLineStartThickness(prevLinesThickness);
            prevLinesThickness += line.getLineThickness();
            int prevChildThickness = 0;
            List<View> childViews = line.getViews();
            int numChildViews = childViews.size();
            for (int j = 0; j < numChildViews; ++j) {
                View child = childViews.get(j);
                LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
                layoutParams.setInlineStartLength(prevChildThickness);
                prevChildThickness += layoutParams.getLength() + layoutParams.getSpacingLength();
            }
        }
    }

    private void applyPositionsToViews(LineDefinition line) {
        List<View> childViews = line.getViews();
        int childCount = childViews.size();
        for (int i = 0; i < childCount; ++i) {
            View child = childViews.get(i);
            LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
            if (this.config.getOrientation() == 0) {
                layoutParams.setPosition(this.getPaddingLeft() + line.getLineStartLength() + layoutParams.getInlineStartLength(), this.getPaddingTop() + line.getLineStartThickness() + layoutParams.getInlineStartThickness());
                child.measure(View.MeasureSpec.makeMeasureSpec((int)layoutParams.getLength(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)layoutParams.getThickness(), (int)0x40000000));
                continue;
            }
            layoutParams.setPosition(this.getPaddingLeft() + line.getLineStartThickness() + layoutParams.getInlineStartThickness(), this.getPaddingTop() + line.getLineStartLength() + layoutParams.getInlineStartLength());
            child.measure(View.MeasureSpec.makeMeasureSpec((int)layoutParams.getThickness(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)layoutParams.getLength(), (int)0x40000000));
        }
    }

    private void applyGravityToLines(List<LineDefinition> lines, int realControlLength, int realControlThickness) {
        int linesCount = lines.size();
        if (linesCount <= 0) {
            return;
        }
        int totalWeight = linesCount;
        LineDefinition lastLine = lines.get(linesCount - 1);
        int excessThickness = realControlThickness - (lastLine.getLineThickness() + lastLine.getLineStartThickness());
        int excessOffset = 0;
        for (int i = 0; i < linesCount; ++i) {
            LineDefinition child = lines.get(i);
            int weight = 1;
            int gravity = this.getGravity();
            int extraThickness = Math.round(excessThickness * weight / totalWeight);
            int childLength = child.getLineLength();
            int childThickness = child.getLineThickness();
            Rect container = new Rect();
            container.top = excessOffset;
            container.left = 0;
            container.right = realControlLength;
            container.bottom = childThickness + extraThickness + excessOffset;
            Rect result = new Rect();
            Gravity.apply((int)gravity, (int)childLength, (int)childThickness, (Rect)container, (Rect)result);
            excessOffset += extraThickness;
            child.addLineStartLength(result.left);
            child.addLineStartThickness(result.top);
            child.setLength(result.width());
            child.setThickness(result.height());
        }
    }

    private void applyGravityToLine(LineDefinition line) {
        List<View> views = line.getViews();
        int viewCount = views.size();
        if (viewCount <= 0) {
            return;
        }
        float totalWeight = 0.0f;
        for (int i = 0; i < viewCount; ++i) {
            View prev = views.get(i);
            LayoutParams plp = (LayoutParams)prev.getLayoutParams();
            totalWeight += this.getWeight(plp);
        }
        View lastChild = views.get(viewCount - 1);
        LayoutParams lastChildLayoutParams = (LayoutParams)lastChild.getLayoutParams();
        int excessLength = line.getLineLength() - (lastChildLayoutParams.getLength() + lastChildLayoutParams.getInlineStartLength());
        int excessOffset = 0;
        for (int i = 0; i < viewCount; ++i) {
            View child = views.get(i);
            LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
            float weight = this.getWeight(layoutParams);
            int gravity = this.getGravity(layoutParams);
            int extraLength = Math.round((float)excessLength * weight / totalWeight);
            int childLength = layoutParams.getLength() + layoutParams.getSpacingLength();
            int childThickness = layoutParams.getThickness() + layoutParams.getSpacingThickness();
            Rect container = new Rect();
            container.top = 0;
            container.left = excessOffset;
            container.right = childLength + extraLength + excessOffset;
            container.bottom = line.getLineThickness();
            Rect result = new Rect();
            Gravity.apply((int)gravity, (int)childLength, (int)childThickness, (Rect)container, (Rect)result);
            excessOffset += extraLength;
            layoutParams.setInlineStartLength(result.left + layoutParams.getInlineStartLength());
            layoutParams.setInlineStartThickness(result.top);
            layoutParams.setLength(result.width() - layoutParams.getSpacingLength());
            layoutParams.setThickness(result.height() - layoutParams.getSpacingThickness());
        }
    }

    private int getGravity(LayoutParams lp) {
        return lp.gravitySpecified() ? lp.gravity : this.config.getGravity();
    }

    private float getWeight(LayoutParams lp) {
        return lp.weightSpecified() ? lp.weight : this.config.getWeightDefault();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(lp.x + lp.leftMargin, lp.y + lp.topMargin, lp.x + lp.leftMargin + child.getMeasuredWidth(), lp.y + lp.topMargin + child.getMeasuredHeight());
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean more = super.drawChild(canvas, child, drawingTime);
        this.drawDebugInfo(canvas, child);
        return more;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private void drawDebugInfo(Canvas canvas, View child) {
        float y;
        float x;
        if (!this.config.isDebugDraw()) {
            return;
        }
        Paint childPaint = this.createPaint(-256);
        Paint newLinePaint = this.createPaint(-65536);
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.rightMargin > 0) {
            x = child.getRight();
            y = (float)child.getTop() + (float)child.getHeight() / 2.0f;
            canvas.drawLine(x, y, x + (float)lp.rightMargin, y, childPaint);
            canvas.drawLine(x + (float)lp.rightMargin - 4.0f, y - 4.0f, x + (float)lp.rightMargin, y, childPaint);
            canvas.drawLine(x + (float)lp.rightMargin - 4.0f, y + 4.0f, x + (float)lp.rightMargin, y, childPaint);
        }
        if (lp.leftMargin > 0) {
            x = child.getLeft();
            y = (float)child.getTop() + (float)child.getHeight() / 2.0f;
            canvas.drawLine(x, y, x - (float)lp.leftMargin, y, childPaint);
            canvas.drawLine(x - (float)lp.leftMargin + 4.0f, y - 4.0f, x - (float)lp.leftMargin, y, childPaint);
            canvas.drawLine(x - (float)lp.leftMargin + 4.0f, y + 4.0f, x - (float)lp.leftMargin, y, childPaint);
        }
        if (lp.bottomMargin > 0) {
            x = (float)child.getLeft() + (float)child.getWidth() / 2.0f;
            y = child.getBottom();
            canvas.drawLine(x, y, x, y + (float)lp.bottomMargin, childPaint);
            canvas.drawLine(x - 4.0f, y + (float)lp.bottomMargin - 4.0f, x, y + (float)lp.bottomMargin, childPaint);
            canvas.drawLine(x + 4.0f, y + (float)lp.bottomMargin - 4.0f, x, y + (float)lp.bottomMargin, childPaint);
        }
        if (lp.topMargin > 0) {
            x = (float)child.getLeft() + (float)child.getWidth() / 2.0f;
            y = child.getTop();
            canvas.drawLine(x, y, x, y - (float)lp.topMargin, childPaint);
            canvas.drawLine(x - 4.0f, y - (float)lp.topMargin + 4.0f, x, y - (float)lp.topMargin, childPaint);
            canvas.drawLine(x + 4.0f, y - (float)lp.topMargin + 4.0f, x, y - (float)lp.topMargin, childPaint);
        }
        if (lp.newLine) {
            if (this.config.getOrientation() == 0) {
                x = child.getLeft();
                y = (float)child.getTop() + (float)child.getHeight() / 2.0f;
                canvas.drawLine(x, y - 6.0f, x, y + 6.0f, newLinePaint);
            } else {
                x = (float)child.getLeft() + (float)child.getWidth() / 2.0f;
                y = child.getTop();
                canvas.drawLine(x - 6.0f, y, x + 6.0f, y, newLinePaint);
            }
        }
    }

    private Paint createPaint(int color) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(color);
        paint.setStrokeWidth(2.0f);
        return paint;
    }

    public int getOrientation() {
        return this.config.getOrientation();
    }

    public void setOrientation(int orientation) {
        this.config.setOrientation(orientation);
        this.requestLayout();
    }

    public boolean isDebugDraw() {
        return this.config.isDebugDraw();
    }

    public void setDebugDraw(boolean debugDraw) {
        this.config.setDebugDraw(debugDraw);
        this.invalidate();
    }

    public float getWeightDefault() {
        return this.config.getWeightDefault();
    }

    public void setWeightDefault(float weightDefault) {
        this.config.setWeightDefault(weightDefault);
        this.requestLayout();
    }

    public int getGravity() {
        return this.config.getGravity();
    }

    public void setGravity(int gravity) {
        this.config.setGravity(gravity);
        this.requestLayout();
    }

    public int getLayoutDirection() {
        if (this.config == null) {
            return 0;
        }
        return this.config.getLayoutDirection();
    }

    public void setLayoutDirection(int layoutDirection) {
        this.config.setLayoutDirection(layoutDirection);
        this.requestLayout();
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public boolean newLine = false;
        @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=48, to="TOP"), @ViewDebug.IntToString(from=80, to="BOTTOM"), @ViewDebug.IntToString(from=3, to="LEFT"), @ViewDebug.IntToString(from=5, to="RIGHT"), @ViewDebug.IntToString(from=16, to="CENTER_VERTICAL"), @ViewDebug.IntToString(from=112, to="FILL_VERTICAL"), @ViewDebug.IntToString(from=1, to="CENTER_HORIZONTAL"), @ViewDebug.IntToString(from=7, to="FILL_HORIZONTAL"), @ViewDebug.IntToString(from=17, to="CENTER"), @ViewDebug.IntToString(from=119, to="FILL")})
        public int gravity = 0;
        public float weight = -1.0f;
        private int spacingLength;
        private int spacingThickness;
        private int inlineStartLength;
        private int length;
        private int thickness;
        private int inlineStartThickness;
        private int x;
        private int y;

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.readStyleParameters(context, attributeSet);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public boolean gravitySpecified() {
            return this.gravity != 0;
        }

        public boolean weightSpecified() {
            return this.weight >= 0.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readStyleParameters(Context context, AttributeSet attributeSet) {
            TypedArray a = context.obtainStyledAttributes(attributeSet, R.styleable.FlowLayout_LayoutParams);
            try {
                this.newLine = a.getBoolean(R.styleable.FlowLayout_LayoutParams_layout_newLine, false);
                this.gravity = a.getInt(R.styleable.FlowLayout_LayoutParams_android_layout_gravity, 0);
                this.weight = a.getFloat(R.styleable.FlowLayout_LayoutParams_layout_weight, -1.0f);
            }
            finally {
                a.recycle();
            }
        }

        void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        int getInlineStartLength() {
            return this.inlineStartLength;
        }

        void setInlineStartLength(int inlineStartLength) {
            this.inlineStartLength = inlineStartLength;
        }

        int getLength() {
            return this.length;
        }

        void setLength(int length) {
            this.length = length;
        }

        int getThickness() {
            return this.thickness;
        }

        void setThickness(int thickness) {
            this.thickness = thickness;
        }

        int getInlineStartThickness() {
            return this.inlineStartThickness;
        }

        void setInlineStartThickness(int inlineStartThickness) {
            this.inlineStartThickness = inlineStartThickness;
        }

        int getSpacingLength() {
            return this.spacingLength;
        }

        int getSpacingThickness() {
            return this.spacingThickness;
        }

        void clearCalculatedFields(int orientation) {
            if (orientation == 0) {
                this.spacingLength = this.leftMargin + this.rightMargin;
                this.spacingThickness = this.topMargin + this.bottomMargin;
            } else {
                this.spacingLength = this.topMargin + this.bottomMargin;
                this.spacingThickness = this.leftMargin + this.rightMargin;
            }
        }
    }
}

