/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.ui.swipeback;

import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import com.x91tec.appshelf.ui.swipeback.SwipePanelLayout;

public final class SwipeConfiguration {
    private float sensitivity = 1.0f;
    private int scrimColor = -1728053248;
    private float velocityThreshold = 5.0f;
    private float distanceThreshold = 0.25f;
    private float edgeSize = 0.18f;
    private float scrimStartAlpha = 0.8f;
    private float scrimEndAlpha = 0.0f;
    @SwipePosition
    private int position = 1;
    private SwipePanelLayout.OnPanelSlideListener listener;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int HORIZONTAL = 3;
    public static final int VERTICAL = 12;

    private SwipeConfiguration() {
    }

    public int getScrimColor() {
        return this.scrimColor;
    }

    public int getPosition() {
        return this.position;
    }

    public float getVelocityThreshold() {
        return this.velocityThreshold;
    }

    public float getDistanceThreshold() {
        return this.distanceThreshold;
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public SwipePanelLayout.OnPanelSlideListener getListener() {
        return this.listener;
    }

    public boolean isCaptureFullScreen() {
        return this.edgeSize == 1.0f;
    }

    public float getEdgeSize(float size) {
        return this.edgeSize * size;
    }

    public float getScrimStartAlpha() {
        return this.scrimStartAlpha;
    }

    public float getScrimEndAlpha() {
        return this.scrimEndAlpha;
    }

    public static class Builder {
        private SwipeConfiguration config = new SwipeConfiguration();

        public Builder position(@SwipePosition int position) {
            this.config.position = position;
            return this;
        }

        public Builder sensitivity(float sensitivity) {
            this.config.sensitivity = sensitivity;
            return this;
        }

        public Builder scrimColor(@ColorInt int color) {
            this.config.scrimColor = color;
            return this;
        }

        public Builder velocityThreshold(float threshold) {
            this.config.velocityThreshold = threshold;
            return this;
        }

        public Builder distanceThreshold(@FloatRange(from=0.10000000149011612, to=0.8999999761581421) float threshold) {
            this.config.distanceThreshold = threshold;
            return this;
        }

        public Builder edgeSize(@FloatRange(from=0.0, to=1.0) float edgeSize) {
            this.config.edgeSize = edgeSize;
            return this;
        }

        public Builder scrimStartAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            this.config.scrimStartAlpha = alpha;
            return this;
        }

        public Builder scrimEndAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            this.config.scrimEndAlpha = alpha;
            return this;
        }

        public Builder listener(SwipePanelLayout.OnPanelSlideListener listener) {
            this.config.listener = listener;
            return this;
        }

        public SwipeConfiguration build() {
            return this.config;
        }
    }

    public static @interface SwipePosition {
    }
}

