/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.ui.swipeback;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewGroupCompat;
import android.support.v4.widget.ViewDragHelper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.x91tec.appshelf.ui.swipeback.SwipeConfiguration;
import com.x91tec.appshelf.ui.swipeback.SwipeController;

public class SwipePanelLayout
extends FrameLayout {
    private static final int MIN_FLING_VELOCITY = 400;
    private final View mContentView;
    private final View mDimView;
    private final ViewDragHelper mDragHelper;
    private final SwipeConfiguration mConfig;
    private OnPanelSlideListener mListener;
    private boolean mIsLocked = false;
    private int mEdgePosition;
    private boolean mIsEdgeTouched = false;

    private SwipePanelLayout(Context context, View contentView, SwipeConfiguration configuration) {
        super(context);
        this.mContentView = contentView;
        this.mConfig = configuration;
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)this.mConfig.getSensitivity(), (ViewDragHelper.Callback)new ViewDragCallback());
        this.mEdgePosition = this.mConfig.getPosition();
        float density = this.getResources().getDisplayMetrics().density;
        float minVel = 400.0f * density;
        this.mDragHelper.setMinVelocity(minVel);
        this.mDragHelper.setEdgeTrackingEnabled(this.mEdgePosition);
        this.mDimView = new View(this.getContext());
        this.mDimView.setBackgroundColor(this.mConfig.getScrimColor());
        this.mDimView.setAlpha(this.mConfig.getScrimStartAlpha());
        this.addView(this.mDimView);
        ViewGroupCompat.setMotionEventSplittingEnabled((ViewGroup)this, (boolean)false);
    }

    public void setOnPanelSlideListener(OnPanelSlideListener listener) {
        this.mListener = listener;
    }

    public void lock() {
        this.mDragHelper.abort();
        this.mIsLocked = true;
    }

    public void unlock() {
        this.mDragHelper.abort();
        this.mIsLocked = false;
    }

    public static SwipeController attachToActivity(final Activity activity, final SwipeConfiguration configuration) {
        TypedArray a = activity.getTheme().obtainStyledAttributes(new int[]{16842836});
        int background = a.getResourceId(0, 0);
        a.recycle();
        ViewGroup decor = (ViewGroup)activity.getWindow().getDecorView();
        ViewGroup decorChild = (ViewGroup)decor.getChildAt(0);
        decorChild.setBackgroundResource(background);
        decor.removeView((View)decorChild);
        final SwipePanelLayout panelLayout = new SwipePanelLayout((Context)activity, (View)decorChild, configuration);
        panelLayout.addView((View)decorChild);
        decor.addView((View)panelLayout);
        panelLayout.setOnPanelSlideListener(new OnPanelSlideListener(){

            @Override
            public void onStateChanged(int state) {
                if (configuration.getListener() != null) {
                    configuration.getListener().onStateChanged(state);
                }
            }

            @Override
            public void onClosed() {
                if (configuration.getListener() != null) {
                    configuration.getListener().onClosed();
                }
                activity.finish();
                activity.overridePendingTransition(0, 0);
            }

            @Override
            public void onOpened() {
                if (configuration.getListener() != null) {
                    configuration.getListener().onOpened();
                }
            }

            @Override
            public void onSlideChange(float percent) {
                if (configuration.getListener() != null) {
                    configuration.getListener().onSlideChange(percent);
                }
            }
        });
        return new SwipeController(){

            @Override
            public void lock() {
                panelLayout.lock();
            }

            @Override
            public void unlock() {
                panelLayout.unlock();
            }
        };
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean interceptForDrag;
        if (this.mIsLocked) {
            return false;
        }
        if (!this.mConfig.isCaptureFullScreen()) {
            this.mIsEdgeTouched = this.canDragFromEdge(ev);
        }
        try {
            interceptForDrag = this.mDragHelper.shouldInterceptTouchEvent(ev);
        }
        catch (Exception e) {
            interceptForDrag = false;
        }
        return interceptForDrag && !this.mIsLocked;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mIsLocked) {
            return false;
        }
        try {
            this.mDragHelper.processTouchEvent(event);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private boolean canDragFromEdge(MotionEvent ev) {
        float x = ev.getX();
        float y = ev.getY();
        switch (this.mConfig.getPosition()) {
            case 4: {
                return y < this.mConfig.getEdgeSize(this.getHeight());
            }
            case 12: {
                return y < this.mConfig.getEdgeSize(this.getHeight()) || y > (float)this.getHeight() - this.mConfig.getEdgeSize(this.getHeight());
            }
        }
        return false;
    }

    static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public void applyScrim(float percent) {
        float alpha = percent * (this.mConfig.getScrimStartAlpha() - this.mConfig.getScrimEndAlpha()) + this.mConfig.getScrimEndAlpha();
        this.mDimView.setAlpha(alpha);
    }

    public static interface OnPanelSlideListener {
        public void onStateChanged(int var1);

        public void onClosed();

        public void onOpened();

        public void onSlideChange(float var1);
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private ViewDragCallback() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            boolean ret = SwipePanelLayout.this.mConfig.isCaptureFullScreen() || (SwipePanelLayout.this.mEdgePosition == 12 || SwipePanelLayout.this.mEdgePosition == 4 ? SwipePanelLayout.this.mIsEdgeTouched : SwipePanelLayout.this.mDragHelper.isEdgeTouched(SwipePanelLayout.this.mEdgePosition, pointerId));
            return ret && SwipePanelLayout.this.mContentView == child;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            int ret = 0;
            int width = child.getWidth();
            if (SwipePanelLayout.this.mEdgePosition == 1) {
                ret = SwipePanelLayout.clamp(left, 0, width);
            } else if (SwipePanelLayout.this.mEdgePosition == 2) {
                ret = SwipePanelLayout.clamp(left, -width, 0);
            } else if (SwipePanelLayout.this.mEdgePosition == 3) {
                ret = SwipePanelLayout.clamp(left, -width, width);
            }
            return ret;
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            int ret = 0;
            int height = child.getHeight();
            if (SwipePanelLayout.this.mEdgePosition == 8) {
                ret = SwipePanelLayout.clamp(top, -height, 0);
            } else if (SwipePanelLayout.this.mEdgePosition == 4) {
                ret = SwipePanelLayout.clamp(top, 0, height);
            } else if (SwipePanelLayout.this.mEdgePosition == 12) {
                ret = SwipePanelLayout.clamp(top, -height, height);
            }
            return ret;
        }

        public int getViewHorizontalDragRange(View child) {
            return SwipePanelLayout.this.mEdgePosition & 3;
        }

        public int getViewVerticalDragRange(View child) {
            return SwipePanelLayout.this.mEdgePosition & 0xC;
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            float percent = 0.0f;
            if (SwipePanelLayout.this.mEdgePosition == 1) {
                percent = 1.0f - (float)left / (float)changedView.getWidth();
            } else if (SwipePanelLayout.this.mEdgePosition == 2) {
                percent = 1.0f - (float)Math.abs(left) / (float)changedView.getWidth();
            } else if (SwipePanelLayout.this.mEdgePosition == 4) {
                percent = 1.0f - (float)Math.abs(top) / (float)changedView.getHeight();
            } else if (SwipePanelLayout.this.mEdgePosition == 8) {
                percent = 1.0f - (float)Math.abs(top) / (float)changedView.getHeight();
            } else if (SwipePanelLayout.this.mEdgePosition == 12) {
                percent = 1.0f - (float)Math.abs(top) / (float)changedView.getHeight();
            } else if (SwipePanelLayout.this.mEdgePosition == 3) {
                percent = 1.0f - (float)Math.abs(left) / (float)changedView.getWidth();
            }
            SwipePanelLayout.this.applyScrim(percent);
            if (SwipePanelLayout.this.mListener != null) {
                SwipePanelLayout.this.mListener.onSlideChange(percent);
            }
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int childWidth = releasedChild.getWidth();
            int childHeight = releasedChild.getHeight();
            float velThreshold = SwipePanelLayout.this.mConfig.getVelocityThreshold();
            int releaseLeft = releasedChild.getLeft();
            int releaseTop = releasedChild.getTop();
            float distanceHorizontalShold = (float)childWidth * SwipePanelLayout.this.mConfig.getDistanceThreshold();
            float distanceVerticalShold = (float)childHeight * SwipePanelLayout.this.mConfig.getDistanceThreshold();
            int left = 0;
            int top = 0;
            if (SwipePanelLayout.this.mEdgePosition == 1) {
                boolean session1 = xvel > 0.0f && (Math.abs(xvel) > velThreshold && Math.abs(yvel) < velThreshold || (float)releaseLeft > distanceHorizontalShold);
                boolean session2 = xvel == 0.0f && (float)releaseLeft > distanceHorizontalShold;
                left = session1 || session2 ? childWidth : 0;
            } else if (SwipePanelLayout.this.mEdgePosition == 2) {
                boolean session1 = xvel < 0.0f && (Math.abs(xvel) > velThreshold && Math.abs(yvel) < velThreshold || (float)releaseLeft < -distanceHorizontalShold);
                boolean session2 = xvel == 0.0f && (float)releaseLeft < -distanceHorizontalShold;
                left = session1 || session2 ? -childWidth : 0;
            } else if (SwipePanelLayout.this.mEdgePosition == 3) {
                if (xvel > 0.0f) {
                    boolean session1 = Math.abs(xvel) > velThreshold && Math.abs(yvel) < velThreshold || (float)releaseLeft > distanceHorizontalShold;
                    left = session1 ? childWidth : 0;
                } else if (xvel < 0.0f) {
                    boolean session1 = Math.abs(xvel) > velThreshold && Math.abs(yvel) < velThreshold || (float)releaseLeft < -distanceHorizontalShold;
                    left = session1 ? -childWidth : 0;
                } else {
                    boolean session2;
                    boolean session1 = (float)releaseLeft > distanceHorizontalShold;
                    boolean bl = session2 = (float)releaseLeft < -distanceHorizontalShold;
                    left = session1 ? childWidth : (session2 ? -childWidth : 0);
                }
            } else if (SwipePanelLayout.this.mEdgePosition == 8) {
                boolean session1 = yvel < 0.0f && (Math.abs(yvel) > velThreshold && Math.abs(xvel) < velThreshold || (float)releaseTop < -distanceVerticalShold);
                boolean session2 = yvel == 0.0f && (float)releaseTop < -distanceVerticalShold;
                top = session1 || session2 ? -childHeight : 0;
            } else if (SwipePanelLayout.this.mEdgePosition == 4) {
                boolean session1 = yvel > 0.0f && (Math.abs(yvel) > velThreshold && Math.abs(xvel) < velThreshold || (float)releaseTop > distanceVerticalShold);
                boolean session2 = yvel == 0.0f && (float)releaseTop > distanceVerticalShold;
                top = session1 || session2 ? childHeight : 0;
            } else if (SwipePanelLayout.this.mEdgePosition == 12) {
                if (yvel > 0.0f) {
                    boolean session1 = Math.abs(yvel) > velThreshold && Math.abs(xvel) < velThreshold || (float)releaseTop > distanceVerticalShold;
                    top = session1 ? childHeight : 0;
                } else if (yvel < 0.0f) {
                    boolean session1 = Math.abs(yvel) > velThreshold && Math.abs(xvel) < velThreshold || (float)releaseTop < -distanceVerticalShold;
                    top = session1 ? -childHeight : 0;
                } else {
                    boolean session2;
                    boolean session1 = (float)releaseTop > distanceVerticalShold;
                    boolean bl = session2 = (float)releaseTop < -distanceVerticalShold;
                    top = session1 ? childHeight : (session2 ? -childHeight : 0);
                }
            }
            SwipePanelLayout.this.mDragHelper.settleCapturedViewAt(left, top);
            SwipePanelLayout.this.invalidate();
        }

        public void onViewDragStateChanged(int state) {
            if (SwipePanelLayout.this.mListener != null) {
                SwipePanelLayout.this.mListener.onStateChanged(state);
            }
            int position = -1;
            if (SwipePanelLayout.this.mEdgePosition == 1 || SwipePanelLayout.this.mEdgePosition == 2 || SwipePanelLayout.this.mEdgePosition == 3) {
                position = SwipePanelLayout.this.mContentView.getLeft();
            } else if (SwipePanelLayout.this.mEdgePosition == 4 || SwipePanelLayout.this.mEdgePosition == 8 || SwipePanelLayout.this.mEdgePosition == 12) {
                position = SwipePanelLayout.this.mContentView.getTop();
            }
            switch (state) {
                case 0: {
                    if (position == 0) {
                        if (SwipePanelLayout.this.mListener == null) break;
                        SwipePanelLayout.this.mListener.onOpened();
                        break;
                    }
                    if (SwipePanelLayout.this.mListener == null) break;
                    SwipePanelLayout.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }
}

