/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.v4;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.x91tec.appshelf.R;
import com.x91tec.appshelf.v4.ViewTool;

public abstract class SupportAppFragmentWrapper<T extends Activity>
extends Fragment {
    private T context;
    private View loadView;
    private FrameLayout failView;
    private View emptyView;
    private View contentFrame;
    private boolean hasCalledFirst = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this.getActivity();
    }

    @Nullable
    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (!this.supportExtraWrapper()) {
            return this.onCreateContentView(inflater, container, savedInstanceState);
        }
        ViewGroup root = this.onCreateRootView(inflater, container, savedInstanceState);
        this.loadView = this.onCreateLoadingView(inflater, container, savedInstanceState);
        if (this.loadView != null) {
            this.loadView.setVisibility(8);
            FrameLayout.LayoutParams loadParam = new FrameLayout.LayoutParams(-2, -2);
            loadParam.gravity = 17;
            root.addView(this.loadView, (ViewGroup.LayoutParams)loadParam);
        }
        this.failView = new FrameLayout(this.getContext());
        this.failView.setVisibility(8);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        root.addView((View)this.failView, (ViewGroup.LayoutParams)params);
        this.contentFrame = this.onCreateContentView(inflater, container, savedInstanceState);
        if (this.contentFrame != null) {
            root.addView(this.contentFrame, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        this.emptyView = this.onCreateEmptyView(inflater, container, savedInstanceState);
        if (this.emptyView != null) {
            this.emptyView.setVisibility(8);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            layoutParams.gravity = 17;
            root.addView(this.emptyView, (ViewGroup.LayoutParams)layoutParams);
        }
        return root;
    }

    public final void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initComponents(view, savedInstanceState);
    }

    public final void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initComponentsData(savedInstanceState);
        if (!this.hasCalledFirst) {
            this.hasCalledFirst = true;
            this.onShowToUserFirst();
        }
    }

    public void onDestroyView() {
        this.contentFrame = null;
        this.failView = null;
        this.emptyView = null;
        this.loadView = null;
        super.onDestroyView();
    }

    protected ViewGroup onCreateRootView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        FrameLayout root = new FrameLayout(this.getContext());
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return root;
    }

    protected View onCreateLoadingView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ProgressBar progressBar = new ProgressBar(this.getContext());
        progressBar.setIndeterminate(false);
        return progressBar;
    }

    protected View onCreateEmptyView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        TextView textView = new TextView(this.getContext());
        textView.setText(R.string.empty_tip);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SupportAppFragmentWrapper.this.onShowToUserFirst();
            }
        });
        return textView;
    }

    protected View onCreateErrorView(LayoutInflater inflater, ViewGroup container, int errorType) {
        TextView textView = new TextView(this.getContext());
        textView.setText(R.string.error_happened);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SupportAppFragmentWrapper.this.onShowToUserFirst();
            }
        });
        return textView;
    }

    protected View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return null;
    }

    public T getContext() {
        return this.context;
    }

    protected void onShowToUserFirst() {
    }

    protected boolean supportExtraWrapper() {
        return true;
    }

    public void showOnLoadFail(int errorType, boolean animate) {
        if (this.failView == null) {
            return;
        }
        ViewTool.hideView(this.contentFrame);
        ViewTool.hideView(this.emptyView);
        if (!ViewTool.equalIntTag((View)this.failView, errorType)) {
            this.failView.removeAllViews();
            View errorView = this.onCreateErrorView(this.getContext().getLayoutInflater(), (ViewGroup)this.failView, errorType);
            this.failView.addView(errorView);
            this.failView.setTag((Object)errorType);
        }
        if (this.failView.getVisibility() == 0) {
            ViewTool.hideView(this.loadView);
            return;
        }
        if (animate) {
            ViewTool.showViewAnimated((View)this.failView);
            ViewTool.hideViewAnimated(this.loadView);
        } else {
            ViewTool.safeClearViewAnimation(this.loadView);
            ViewTool.safeClearViewAnimation((View)this.failView);
            ViewTool.safeClearViewAnimation(this.contentFrame);
            ViewTool.safeClearViewAnimation(this.emptyView);
        }
        ViewTool.showView((View)this.failView);
        ViewTool.hideView(this.loadView);
    }

    public void showOnBindData(boolean animate) {
        if (this.contentFrame == null) {
            return;
        }
        ViewTool.hideView((View)this.failView);
        ViewTool.hideView(this.emptyView);
        if (this.contentFrame.getVisibility() == 0) {
            ViewTool.hideView(this.loadView);
            return;
        }
        if (animate) {
            ViewTool.showViewAnimated(this.contentFrame);
            ViewTool.hideViewAnimated(this.loadView);
        } else {
            ViewTool.safeClearViewAnimation(this.loadView);
            ViewTool.safeClearViewAnimation((View)this.failView);
            ViewTool.safeClearViewAnimation(this.contentFrame);
            ViewTool.safeClearViewAnimation(this.emptyView);
        }
        ViewTool.showView(this.contentFrame);
        ViewTool.hideView(this.loadView);
    }

    public void showOnEmpty(boolean animate) {
        if (this.emptyView == null) {
            return;
        }
        ViewTool.hideView((View)this.failView);
        ViewTool.hideView(this.contentFrame);
        if (this.emptyView.getVisibility() == 0) {
            ViewTool.hideView(this.loadView);
            return;
        }
        if (animate) {
            ViewTool.showViewAnimated(this.emptyView);
            ViewTool.hideViewAnimated(this.loadView);
        } else {
            ViewTool.safeClearViewAnimation(this.loadView);
            ViewTool.safeClearViewAnimation((View)this.failView);
            ViewTool.safeClearViewAnimation(this.contentFrame);
            ViewTool.safeClearViewAnimation(this.emptyView);
        }
        ViewTool.showView(this.emptyView);
        ViewTool.hideView(this.loadView);
    }

    public void showOnLoading(boolean animate) {
        if (this.loadView == null) {
            return;
        }
        ViewTool.hideView((View)this.failView);
        ViewTool.hideView(this.emptyView);
        if (this.loadView.getVisibility() == 0) {
            ViewTool.hideView(this.contentFrame);
            return;
        }
        if (animate) {
            ViewTool.showViewAnimated(this.loadView);
            ViewTool.hideViewAnimated(this.contentFrame);
        } else {
            ViewTool.safeClearViewAnimation(this.loadView);
            ViewTool.safeClearViewAnimation((View)this.failView);
            ViewTool.safeClearViewAnimation(this.contentFrame);
            ViewTool.safeClearViewAnimation(this.emptyView);
        }
        ViewTool.showView(this.loadView);
        ViewTool.hideView(this.contentFrame);
    }

    protected abstract void initComponents(View var1, Bundle var2);

    protected abstract void initComponentsData(Bundle var1);
}

