/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.v4;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.x91tec.appshelf.R;
import com.x91tec.appshelf.v4.ViewTool;

public abstract class SupportAppListFragmentWrapper<T extends Activity>
extends Fragment {
    private final Handler mHandler = new Handler();
    private final Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            SupportAppListFragmentWrapper.this.mList.focusableViewAvailable((View)SupportAppListFragmentWrapper.this.mList);
        }
    };
    private final AdapterView.OnItemClickListener mOnClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
            SupportAppListFragmentWrapper.this.onListItemClick((ListView)parent, v, position, id2);
        }
    };
    ListAdapter mAdapter;
    FrameLayout mContentView;
    ListView mList;
    View loadView;
    View mEmptyView;
    FrameLayout mErrorView;
    public T context;
    private boolean hasCalledFirst = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this.getActivity();
    }

    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (!this.supportExtraWrapper()) {
            View listViewContainer = this.onCreateListView(inflater, container, savedInstanceState);
            this.mList = (ListView)listViewContainer.findViewById(16908298);
            this.mEmptyView = listViewContainer.findViewById(16908292);
            if (this.mEmptyView != null) {
                this.mList.setEmptyView(this.mEmptyView);
            }
            return listViewContainer;
        }
        ViewGroup root = this.onCreateRootView(inflater, container, savedInstanceState);
        this.loadView = this.onCreateLoadingView(inflater, container, savedInstanceState);
        if (this.loadView != null) {
            this.loadView.setVisibility(8);
            FrameLayout.LayoutParams loadParam = new FrameLayout.LayoutParams(-2, -2);
            loadParam.gravity = 17;
            root.addView(this.loadView, (ViewGroup.LayoutParams)loadParam);
        }
        this.mErrorView = new FrameLayout(this.context);
        this.mErrorView.setVisibility(8);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        root.addView((View)this.mErrorView, (ViewGroup.LayoutParams)params);
        this.mContentView = new FrameLayout(this.context);
        root.addView((View)this.mContentView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mEmptyView = this.onCreateEmptyView(inflater, container, savedInstanceState);
        if (this.mEmptyView != null) {
            this.mEmptyView.setVisibility(8);
            FrameLayout.LayoutParams emptyParam = new FrameLayout.LayoutParams(-2, -2);
            emptyParam.gravity = 17;
            this.mContentView.addView(this.mEmptyView, (ViewGroup.LayoutParams)emptyParam);
        }
        View listViewContainer = this.onCreateListView(inflater, container, savedInstanceState);
        this.mList = (ListView)listViewContainer.findViewById(16908298);
        if (this.mEmptyView != null) {
            this.mList.setEmptyView(this.mEmptyView);
        }
        this.mContentView.addView(listViewContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        return root;
    }

    public final void onViewCreated(View root, Bundle savedInstanceState) {
        super.onViewCreated(root, savedInstanceState);
        this.mList.setOnItemClickListener(this.mOnClickListener);
        this.mHandler.post(this.mRequestFocus);
        this.initComponents(root, savedInstanceState);
    }

    public final void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initComponentsData(savedInstanceState);
        if (!this.hasCalledFirst) {
            this.hasCalledFirst = true;
            this.onShowToUserFirst();
        }
    }

    public void onDestroyView() {
        this.mHandler.removeCallbacks(this.mRequestFocus);
        this.mList = null;
        this.mErrorView = null;
        this.mContentView = null;
        this.mEmptyView = null;
        this.loadView = null;
        super.onDestroyView();
    }

    public void onListItemClick(ListView l, View v, int position, long id2) {
    }

    public void setListAdapter(ListAdapter adapter) {
        boolean hadAdapter = this.mAdapter != null;
        this.mAdapter = adapter;
        if (this.mList != null) {
            this.mList.setAdapter(adapter);
            if (!ViewTool.isViewVisible((View)this.mContentView) && !hadAdapter) {
                this.showOnBindData(this.getView().getWindowToken() != null);
            }
        }
    }

    public void setSelection(int position) {
        this.mList.setSelection(position);
    }

    public int getSelectedItemPosition() {
        return this.mList.getSelectedItemPosition();
    }

    public long getSelectedItemId() {
        return this.mList.getSelectedItemId();
    }

    public ListView getListView() {
        return this.mList;
    }

    public void setEmptyText(CharSequence text) {
        TextView emptyText;
        if (this.mEmptyView != null && (emptyText = (TextView)this.mEmptyView.findViewById(16908292)) != null) {
            emptyText.setText(text);
        }
    }

    public ListAdapter getListAdapter() {
        return this.mAdapter;
    }

    protected ViewGroup onCreateRootView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        FrameLayout root = new FrameLayout(this.getContext());
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return root;
    }

    protected View onCreateLoadingView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ProgressBar progressBar = new ProgressBar(this.getContext());
        progressBar.setIndeterminate(false);
        return progressBar;
    }

    protected View onCreateEmptyView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        TextView textView = new TextView(this.getContext());
        textView.setText(R.string.empty_tip);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SupportAppListFragmentWrapper.this.onShowToUserFirst();
            }
        });
        return textView;
    }

    protected View onCreateErrorView(LayoutInflater inflater, ViewGroup container, int errorType) {
        TextView textView = new TextView(this.getContext());
        textView.setText(R.string.error_happened);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SupportAppListFragmentWrapper.this.onShowToUserFirst();
            }
        });
        return textView;
    }

    protected View onCreateListView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ListView lv = new ListView(this.context);
        lv.setCacheColorHint(0);
        lv.setId(16908298);
        lv.setDrawSelectorOnTop(false);
        return lv;
    }

    protected void showOnBindData(boolean animate) {
        if (this.mContentView == null) {
            return;
        }
        ViewTool.hideView((View)this.mErrorView);
        if (ViewTool.isViewVisible((View)this.mContentView)) {
            ViewTool.hideView(this.loadView);
            return;
        }
        if (animate) {
            ViewTool.showViewAnimated((View)this.mContentView);
            ViewTool.hideView(this.loadView);
        } else {
            ViewTool.safeClearViewAnimation((View)this.mContentView);
            ViewTool.safeClearViewAnimation(this.loadView);
            ViewTool.safeClearViewAnimation((View)this.mErrorView);
        }
        ViewTool.showView((View)this.mContentView);
        ViewTool.hideView(this.loadView);
    }

    public void showOnLoading(boolean animate) {
        if (this.loadView == null) {
            return;
        }
        ViewTool.hideView((View)this.mContentView);
        if (ViewTool.isViewVisible(this.loadView)) {
            ViewTool.hideView((View)this.mErrorView);
            return;
        }
        if (animate) {
            ViewTool.showViewAnimated(this.loadView);
            ViewTool.hideViewAnimated((View)this.mErrorView);
        } else {
            ViewTool.safeClearViewAnimation(this.loadView);
            ViewTool.safeClearViewAnimation((View)this.mErrorView);
            ViewTool.safeClearViewAnimation((View)this.mContentView);
        }
        ViewTool.showView(this.loadView);
        ViewTool.hideView((View)this.mErrorView);
    }

    public void showOnLoadFail(int errorType, boolean animate) {
        if (this.mErrorView == null) {
            return;
        }
        ViewTool.hideView((View)this.mContentView);
        if (!ViewTool.equalIntTag((View)this.mErrorView, errorType)) {
            this.mErrorView.removeAllViews();
            View errorView = this.onCreateErrorView(this.getContext().getLayoutInflater(), (ViewGroup)this.mErrorView, errorType);
            this.mErrorView.addView(errorView);
            this.mErrorView.setTag((Object)errorType);
        }
        if (ViewTool.isViewVisible((View)this.mErrorView)) {
            ViewTool.hideView(this.loadView);
            return;
        }
        if (animate) {
            ViewTool.showViewAnimated((View)this.mErrorView);
            ViewTool.hideViewAnimated(this.loadView);
        } else {
            ViewTool.safeClearViewAnimation(this.loadView);
            ViewTool.safeClearViewAnimation((View)this.mErrorView);
            ViewTool.safeClearViewAnimation((View)this.mContentView);
        }
        ViewTool.showView((View)this.mErrorView);
        ViewTool.hideView(this.loadView);
    }

    public T getContext() {
        return this.context;
    }

    protected void onShowToUserFirst() {
    }

    protected boolean supportExtraWrapper() {
        return true;
    }

    protected abstract void initComponents(View var1, Bundle var2);

    protected abstract void initComponentsData(Bundle var1);
}

