/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.v7;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BasicRecyclerViewAdapter<VH extends RecyclerView.ViewHolder, T>
extends RecyclerView.Adapter<VH> {
    private final List<T> mListData = new ArrayList<T>();
    private LayoutInflater mLayoutInflater;
    private Context context;

    public BasicRecyclerViewAdapter(Context context) {
        this(context, null);
    }

    public BasicRecyclerViewAdapter(Context context, List<T> list) {
        this.context = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        if (list != null) {
            this.mListData.addAll(list);
        }
    }

    public VH onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.onCreateRecycleItemView(this.mLayoutInflater, parent, viewType);
    }

    public void onBindViewHolder(VH holder, int position) {
        this.onBindItemViewData(holder, position, this.mListData.get(position));
    }

    public int getItemViewType(int position) {
        T t = this.mListData.get(position);
        return this.generateViewType(position, t);
    }

    public int getItemCount() {
        return this.mListData.size();
    }

    public void changeDataSet(boolean keepOld, T ... newData) {
        this.changeDataSet(keepOld, Arrays.asList(newData));
    }

    public void changeDataSet(boolean keepOld, List<T> newData) {
        if (!keepOld) {
            this.mListData.clear();
        }
        if (newData != null) {
            this.mListData.addAll(newData);
        }
    }

    public void clearRecyclerData() {
        this.mListData.clear();
    }

    protected Context getContext() {
        return this.context;
    }

    public List<T> getListData() {
        return this.mListData;
    }

    protected abstract void onBindItemViewData(VH var1, int var2, T var3);

    protected abstract VH onCreateRecycleItemView(LayoutInflater var1, ViewGroup var2, int var3);

    protected int generateViewType(int itemPosition, T data) {
        return 0;
    }
}

