/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.v7;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.developer.bsince.log.GOL;
import com.x91tec.appshelf.v7.XDividerDecoration;

public class DecorationFactory {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public static class Builder {
        private static final int[] ATTRS = new int[]{16843284};
        private static final int DEFAULT_SIZE = 2;
        boolean gridLayout = false;
        boolean paintBottomOfEnd = false;
        DecorationPainter mDecorationPainter;
        VisibilityProvider mVisibilityProvider;
        MarginProvider mMarginProvider;
        OrientationHandler mOrientationHandler;
        boolean isDrawablePaint = false;
        SizeProvider mSizeProvider;

        public Builder paint(final Paint paint) {
            return this.paintProvider(new PaintProvider(){

                @Override
                public Paint dividerPaint(int position, RecyclerView parent) {
                    return paint;
                }
            });
        }

        public Builder paintProvider(PaintProvider provider) {
            return this.decorationPainter(new PaintPainter(provider));
        }

        public Builder color(final int color) {
            return this.colorProvider(new ColorProvider(){

                @Override
                public int dividerColor(int position, RecyclerView parent) {
                    return color;
                }
            });
        }

        public Builder color(final int color, int size) {
            return this.colorProvider(new ColorProvider(){

                @Override
                public int dividerColor(int position, RecyclerView parent) {
                    return color;
                }
            }, size);
        }

        public Builder colorProvider(ColorProvider colorProvider) {
            return this.decorationPainter(new ColorPainter(colorProvider, this.generateSizeProvider(2)));
        }

        public Builder colorProvider(ColorProvider colorProvider, int size) {
            return this.decorationPainter(new ColorPainter(colorProvider, this.generateSizeProvider(size)));
        }

        public Builder colorProvider(ColorProvider colorProvider, @NonNull SizeProvider sizeProvider) {
            return this.decorationPainter(new ColorPainter(colorProvider, sizeProvider));
        }

        public Builder drawable(final Drawable d) {
            return this.drawableProvider(new DrawableProvider(){

                @Override
                public Drawable drawableProvider(int position, RecyclerView parent) {
                    return d;
                }
            });
        }

        public Builder drawableProvider(DrawableProvider drawableProvider) {
            return this.decorationPainter(new DrawablePainter(drawableProvider));
        }

        public Builder defaultPainter(Context context) {
            TypedArray a = context.obtainStyledAttributes(ATTRS);
            final Drawable divider = a.getDrawable(0);
            a.recycle();
            this.mDecorationPainter = new DrawablePainter(new DrawableProvider(){

                @Override
                public Drawable drawableProvider(int position, RecyclerView parent) {
                    return divider;
                }
            });
            return this;
        }

        public Builder decorationPainter(DecorationPainter painter) {
            this.mDecorationPainter = painter;
            this.isDrawablePaint = painter instanceof DrawablePainter;
            return this;
        }

        public Builder visibilityProvider(VisibilityProvider visibilityProvider) {
            this.mVisibilityProvider = visibilityProvider;
            return this;
        }

        public Builder paintBottom(boolean flag) {
            this.paintBottomOfEnd = flag;
            return this;
        }

        public Builder orientation(@Orientation int orientation) {
            this.mOrientationHandler = orientation == 0 ? new HorizontalHandler() : new VerticalHandler();
            return this;
        }

        public Builder gridLayout(boolean flag) {
            this.gridLayout = flag;
            return this;
        }

        public Builder margin(final int leftMargin, final int rightMargin) {
            return this.marginProvider(new MarginProvider(){

                @Override
                public int dividerStartMargin(int position, RecyclerView parent) {
                    return leftMargin;
                }

                @Override
                public int dividerEndMargin(int position, RecyclerView parent) {
                    return rightMargin;
                }
            });
        }

        public Builder margin(int horizontalMargin) {
            return this.margin(horizontalMargin, horizontalMargin);
        }

        public Builder marginProvider(MarginProvider provider) {
            this.mMarginProvider = provider;
            return this;
        }

        public Builder onlySize(int size) {
            return this.onlySizeProvider(this.generateSizeProvider(size));
        }

        public Builder onlySizeProvider(SizeProvider sizeProvider) {
            this.mSizeProvider = sizeProvider;
            return this;
        }

        SizeProvider generateSizeProvider(final int size) {
            return new SizeProvider(){

                @Override
                public int dividerSize(int position, RecyclerView parent) {
                    return size;
                }
            };
        }

        public XDividerDecoration build() {
            this.checkParams();
            return new XDividerDecoration(this);
        }

        void checkParams() {
            if (this.mDecorationPainter == null) {
                GOL.e((String)"DecorationPainter is null", (Object[])new Object[0]);
                if (this.mSizeProvider == null) {
                    GOL.e((String)"offset size will be zero", (Object[])new Object[0]);
                }
            }
            if (this.mVisibilityProvider == null) {
                GOL.e((String)"VisibilityProvider is null", (Object[])new Object[0]);
            }
            if (this.mMarginProvider == null) {
                GOL.e((String)"MarginProvider is null", (Object[])new Object[0]);
            }
            if (this.mOrientationHandler == null) {
                this.mOrientationHandler = new HorizontalHandler();
            }
        }
    }

    public static class VerticalHandler
    implements OrientationHandler {
        @Override
        public Rect dividerBoundsSetting(RecyclerView parent, View child, int marginStart, int marginEnd, int dividerSize, boolean isDrawablePaint) {
            Rect bounds = new Rect(0, 0, 0, 0);
            int transitionX = (int)ViewCompat.getTranslationX((View)child);
            int transitionY = (int)ViewCompat.getTranslationY((View)child);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            bounds.top = parent.getPaddingTop() + marginStart + transitionY;
            bounds.bottom = parent.getHeight() - parent.getPaddingBottom() - marginEnd + transitionY;
            if (isDrawablePaint) {
                bounds.left = child.getRight() + params.leftMargin + transitionX;
                bounds.right = bounds.left + dividerSize;
            } else {
                bounds.right = bounds.left = child.getRight() + params.leftMargin + dividerSize / 2 + transitionX;
            }
            return bounds;
        }

        @Override
        public void setItemOffsets(Rect outRect, int position, int dividerSize) {
            outRect.set(0, 0, dividerSize, 0);
        }
    }

    public static class HorizontalHandler
    implements OrientationHandler {
        @Override
        public Rect dividerBoundsSetting(RecyclerView parent, View child, int marginStart, int marginEnd, int dividerSize, boolean isDrawablePaint) {
            Rect bounds = new Rect(0, 0, 0, 0);
            int transitionX = (int)ViewCompat.getTranslationX((View)child);
            int transitionY = (int)ViewCompat.getTranslationY((View)child);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            bounds.left = parent.getPaddingLeft() + marginStart + transitionX;
            bounds.right = parent.getWidth() - parent.getPaddingRight() - marginEnd + transitionX;
            if (isDrawablePaint) {
                bounds.top = child.getBottom() + params.topMargin + transitionY;
                bounds.bottom = bounds.top + dividerSize;
            } else {
                bounds.bottom = bounds.top = child.getBottom() + params.topMargin + dividerSize / 2 + transitionY;
            }
            return bounds;
        }

        @Override
        public void setItemOffsets(Rect outRect, int position, int dividerSize) {
            outRect.set(0, 0, 0, dividerSize);
        }
    }

    static class DrawablePainter
    implements DecorationPainter {
        private DrawableProvider mDrawableProvider;

        public DrawablePainter(DrawableProvider mDrawableProvider) {
            this.mDrawableProvider = mDrawableProvider;
        }

        @Override
        public void painting(RecyclerView recyclerView, Canvas canvas, Rect bounds, int position) {
            Drawable drawable = this.mDrawableProvider.drawableProvider(position, recyclerView);
            drawable.setBounds(bounds);
            drawable.draw(canvas);
        }

        @Override
        public int dividerSize(int position, RecyclerView parent) {
            Drawable drawable = this.mDrawableProvider.drawableProvider(position, parent);
            return drawable.getIntrinsicHeight();
        }
    }

    static class ColorPainter
    implements DecorationPainter {
        private ColorProvider mColorProvider;
        private Paint mPaint;
        private SizeProvider mSizeProvider;

        public ColorPainter(ColorProvider mColorProvider, SizeProvider sizeProvider) {
            this.mColorProvider = mColorProvider;
            this.mSizeProvider = sizeProvider;
            this.mPaint = new Paint();
        }

        @Override
        public void painting(RecyclerView recyclerView, Canvas canvas, Rect bounds, int position) {
            int color = this.mColorProvider.dividerColor(position, recyclerView);
            this.mPaint.setColor(color);
            this.mPaint.setStrokeWidth((float)this.dividerSize(position, recyclerView));
            canvas.drawLine((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
        }

        @Override
        public int dividerSize(int position, RecyclerView parent) {
            return this.mSizeProvider.dividerSize(position, parent);
        }
    }

    static class PaintPainter
    implements DecorationPainter {
        public PaintProvider mPaintProvider;
        private Paint mPaint;

        public PaintPainter(@NonNull PaintProvider mPaintProvider) {
            this.mPaintProvider = mPaintProvider;
        }

        @Override
        public void painting(RecyclerView recyclerView, Canvas canvas, Rect bounds, int position) {
            this.mPaint = this.mPaintProvider.dividerPaint(position, recyclerView);
            canvas.drawLine((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
        }

        @Override
        public int dividerSize(int position, RecyclerView parent) {
            return (int)this.mPaintProvider.dividerPaint(position, parent).getStrokeWidth();
        }
    }

    static class GridItemInfoProvider
    implements ItemInfoProvider {
        GridItemInfoProvider() {
        }

        @Override
        public int lastDividerOffset(RecyclerView parent) {
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            GridLayoutManager.SpanSizeLookup spanSizeLookup = layoutManager.getSpanSizeLookup();
            int spanCount = layoutManager.getSpanCount();
            int itemCount = parent.getAdapter().getItemCount();
            for (int i = itemCount - 1; i >= 0; --i) {
                if (spanSizeLookup.getSpanIndex(i, spanCount) != 0) continue;
                return itemCount - i;
            }
            return 1;
        }

        @Override
        public int itemIndex(int position, RecyclerView parent) {
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            GridLayoutManager.SpanSizeLookup spanSizeLookup = layoutManager.getSpanSizeLookup();
            int spanCount = layoutManager.getSpanCount();
            return spanSizeLookup.getSpanGroupIndex(position, spanCount);
        }

        @Override
        public boolean hasItemDrawnDivider(int position, RecyclerView parent) {
            int spanCount;
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            GridLayoutManager.SpanSizeLookup spanSizeLookup = layoutManager.getSpanSizeLookup();
            return spanSizeLookup.getSpanIndex(position, spanCount = layoutManager.getSpanCount()) > 0;
        }
    }

    static class LinerItemInfoProvider
    implements ItemInfoProvider {
        LinerItemInfoProvider() {
        }

        @Override
        public int lastDividerOffset(RecyclerView parent) {
            return 1;
        }

        @Override
        public int itemIndex(int position, RecyclerView parent) {
            return position;
        }

        @Override
        public boolean hasItemDrawnDivider(int position, RecyclerView parent) {
            return false;
        }
    }

    public static interface OrientationHandler {
        public Rect dividerBoundsSetting(RecyclerView var1, View var2, int var3, int var4, int var5, boolean var6);

        public void setItemOffsets(Rect var1, int var2, int var3);
    }

    public static interface ItemInfoProvider {
        public int lastDividerOffset(RecyclerView var1);

        public int itemIndex(int var1, RecyclerView var2);

        public boolean hasItemDrawnDivider(int var1, RecyclerView var2);
    }

    public static interface DecorationPainter {
        public void painting(RecyclerView var1, Canvas var2, Rect var3, int var4);

        public int dividerSize(int var1, RecyclerView var2);
    }

    public static interface MarginProvider {
        public int dividerStartMargin(int var1, RecyclerView var2);

        public int dividerEndMargin(int var1, RecyclerView var2);
    }

    public static interface VisibilityProvider {
        public boolean shouldHideDivider(int var1, RecyclerView var2);
    }

    public static interface ColorProvider {
        public int dividerColor(int var1, RecyclerView var2);
    }

    public static interface DrawableProvider {
        public Drawable drawableProvider(int var1, RecyclerView var2);
    }

    public static interface SizeProvider {
        public int dividerSize(int var1, RecyclerView var2);
    }

    public static interface PaintProvider {
        public Paint dividerPaint(int var1, RecyclerView var2);
    }

    public static @interface Orientation {
    }
}

