/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.v7;

import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.x91tec.appshelf.v7.PageLoadingFooter;

public final class RecyclerFactory {

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }
    }

    public static class PageLoadingFooterAdapter
    extends SingleExtraAdapter {
        private PageLoadingFooter pageLoadingFooter;

        public PageLoadingFooterAdapter(PageLoadingFooter pageLoadingFooter) {
            this.pageLoadingFooter = pageLoadingFooter;
            this.addExtraView(0, pageLoadingFooter.getLoadingLayout());
        }

        public void startLoading() {
            if (this.pageLoadingFooter.getLoadingState() == 1) {
                return;
            }
            this.pageLoadingFooter.onStartLoading();
        }

        public void finishLoading() {
            if (this.pageLoadingFooter.getLoadingState() == 0) {
                return;
            }
            this.pageLoadingFooter.onLoadingComplete();
        }

        public void loadErrorHappened() {
            if (this.pageLoadingFooter.getLoadingState() == 2) {
                return;
            }
            this.pageLoadingFooter.onLoadingError();
        }

        public void loadLastPage() {
            if (this.pageLoadingFooter.getLoadingState() == 3) {
                return;
            }
            this.pageLoadingFooter.onReachToLastPage();
        }

        public int getLoadingState() {
            return this.pageLoadingFooter.getLoadingState();
        }
    }

    public static interface IViewDataBinder {
        public void onBindExtraView(int var1, RecyclerView.ViewHolder var2);
    }

    public static class SingleExtraAdapter
    implements RecyclerExtraAdapter {
        private IViewDataBinder iBinder;
        private View extraView;

        public SingleExtraAdapter(IViewDataBinder iBinder) {
            this.iBinder = iBinder;
        }

        public SingleExtraAdapter() {
            this.iBinder = null;
        }

        @Override
        public int getCount() {
            return this.extraView == null ? 0 : 1;
        }

        @Override
        public void addExtraView(int position, View extraView) {
            this.extraView = extraView;
        }

        @Override
        public void removeExtraView(int position) {
            this.extraView = null;
        }

        @Override
        public ViewHolder onCreateExtraView(ViewGroup parent, int position) {
            return new ViewHolder(this.extraView);
        }

        @Override
        public void setIViewDataBinder(IViewDataBinder dataBinder) {
            this.iBinder = dataBinder;
        }

        @Override
        public void onBindExtraView(int position, RecyclerView.ViewHolder viewHolder) {
            if (this.iBinder != null) {
                this.iBinder.onBindExtraView(position, viewHolder);
            }
        }
    }

    public static class BasicRecyclerExtraAdapter
    implements RecyclerExtraAdapter {
        private final SparseArray<View> mExtras = new SparseArray();
        private IViewDataBinder iBinder;

        @Override
        public int getCount() {
            return this.mExtras.size();
        }

        @Override
        public void addExtraView(int position, View extraView) {
            this.mExtras.put(position, (Object)extraView);
        }

        @Override
        public void removeExtraView(int position) {
            this.mExtras.remove(position);
        }

        @Override
        public ViewHolder onCreateExtraView(ViewGroup parent, int position) {
            View extraView = (View)this.mExtras.get(position);
            return new ViewHolder(extraView);
        }

        @Override
        public void setIViewDataBinder(IViewDataBinder dataBinder) {
            this.iBinder = dataBinder;
        }

        @Override
        public void onBindExtraView(int position, RecyclerView.ViewHolder viewHolder) {
            if (this.iBinder != null) {
                this.iBinder.onBindExtraView(position, viewHolder);
            }
        }
    }

    public static interface RecyclerExtraAdapter
    extends IViewDataBinder {
        public int getCount();

        public void addExtraView(int var1, View var2);

        public void removeExtraView(int var1);

        public RecyclerView.ViewHolder onCreateExtraView(ViewGroup var1, int var2);

        public void setIViewDataBinder(IViewDataBinder var1);
    }

    public static class RecyclerViewType {
        public static final int VIEW_TYPE_HEADER = Integer.MIN_VALUE;
        public static final int VIEW_TYPE_FOOTER = -1073741824;
    }
}

