/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.v7;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.x91tec.appshelf.v7.RecyclerFactory;

public class RecyclerViewAdapterWrapper
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private RecyclerView.Adapter mInnerAdapter;
    private RecyclerFactory.RecyclerExtraAdapter mHeaderFactory;
    private RecyclerFactory.RecyclerExtraAdapter mFooterFactory;
    private RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            RecyclerViewAdapterWrapper.this.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            RecyclerViewAdapterWrapper.this.notifyItemRangeChanged(positionStart + RecyclerViewAdapterWrapper.this.getHeaderCount(), itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            RecyclerViewAdapterWrapper.this.notifyItemRangeInserted(positionStart + RecyclerViewAdapterWrapper.this.getHeaderCount(), itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            RecyclerViewAdapterWrapper.this.notifyItemRangeRemoved(positionStart + RecyclerViewAdapterWrapper.this.getHeaderCount(), itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            int headerViewsCountCount = RecyclerViewAdapterWrapper.this.getHeaderCount();
            RecyclerViewAdapterWrapper.this.notifyItemRangeChanged(fromPosition + headerViewsCountCount, toPosition + headerViewsCountCount + itemCount);
        }
    };

    public RecyclerViewAdapterWrapper() {
        this(null);
    }

    public RecyclerViewAdapterWrapper(RecyclerView.Adapter mInnerAdapter) {
        this.setAdapter(mInnerAdapter);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (adapter == null) {
            return;
        }
        if (this.mInnerAdapter != null) {
            this.notifyItemRangeRemoved(this.getHeaderCount(), this.mInnerAdapter.getItemCount());
            this.mInnerAdapter.unregisterAdapterDataObserver(this.mDataObserver);
        }
        this.mInnerAdapter = adapter;
        this.mInnerAdapter.registerAdapterDataObserver(this.mDataObserver);
        this.notifyItemRangeInserted(this.getHeaderCount(), this.mInnerAdapter.getItemCount());
    }

    public void setHeaderFactory(RecyclerFactory.RecyclerExtraAdapter mHeaderFactory) {
        this.mHeaderFactory = mHeaderFactory;
    }

    public void setFooterFactory(RecyclerFactory.RecyclerExtraAdapter mFooterFactory) {
        this.mFooterFactory = mFooterFactory;
    }

    public RecyclerView.Adapter getInnerAdapter() {
        return this.mInnerAdapter;
    }

    public RecyclerFactory.RecyclerExtraAdapter getHeaderAdapter() {
        return this.mHeaderFactory;
    }

    public RecyclerFactory.RecyclerExtraAdapter getFooterAdapter() {
        return this.mFooterFactory;
    }

    public int getItemViewType(int position) {
        int innerCount = this.mInnerAdapter == null ? 0 : this.mInnerAdapter.getItemCount();
        int headerCount = this.getHeaderCount();
        if (position < headerCount) {
            return Integer.MIN_VALUE + position;
        }
        if (headerCount <= position && position < headerCount + innerCount) {
            assert (this.mInnerAdapter != null);
            int innerItemViewType = this.mInnerAdapter.getItemViewType(position - headerCount);
            if (innerItemViewType >= 0x3FFFFFFF) {
                throw new IllegalArgumentException("your adapter's return value of getItemViewType() must < Integer.MAX_VALUE / 2");
            }
            return innerItemViewType + 0x3FFFFFFF;
        }
        return -1073741824 + position - headerCount - innerCount;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        int headerViewsCountCount = this.getHeaderCount();
        if (viewType < Integer.MIN_VALUE + headerViewsCountCount) {
            int position = viewType - Integer.MIN_VALUE;
            return this.mHeaderFactory.onCreateExtraView(parent, position);
        }
        if (viewType >= -1073741824 && viewType < 0x3FFFFFFF) {
            int position = viewType - -1073741824;
            return this.mFooterFactory.onCreateExtraView(parent, position);
        }
        return this.mInnerAdapter.onCreateViewHolder(parent, viewType - 0x3FFFFFFF);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int headerViewsCountCount = this.getHeaderCount();
        int viewType = holder.getItemViewType();
        if (viewType >= 0x3FFFFFFF) {
            if (this.mInnerAdapter != null) {
                this.mInnerAdapter.onBindViewHolder(holder, position - headerViewsCountCount);
            }
        } else if (position < headerViewsCountCount) {
            this.mHeaderFactory.onBindExtraView(position, holder);
        } else {
            int realPosition = viewType - -1073741824;
            this.mFooterFactory.onBindExtraView(realPosition, holder);
        }
    }

    public int getItemCount() {
        int innerCount = this.mInnerAdapter == null ? 0 : this.mInnerAdapter.getItemCount();
        return this.getHeaderCount() + this.getFooterCount() + innerCount;
    }

    int getHeaderCount() {
        return this.mHeaderFactory == null ? 0 : this.mHeaderFactory.getCount();
    }

    int getFooterCount() {
        return this.mFooterFactory == null ? 0 : this.mFooterFactory.getCount();
    }

    public long getItemId(int position) {
        return super.getItemId(position);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        if (this.mInnerAdapter != null) {
            this.mInnerAdapter.onAttachedToRecyclerView(recyclerView);
        }
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        if (this.mInnerAdapter != null) {
            this.mInnerAdapter.onDetachedFromRecyclerView(recyclerView);
        }
    }
}

