/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.v7;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import com.x91tec.appshelf.v7.IDataGetter;

public class RecyclerViewScrollUpListener
extends RecyclerView.OnScrollListener {
    public static final int LINEAR_LAYOUT = 0;
    public static final int GRID_LAYOUT = 1;
    public static final int STAGGERED_GRID_LAYOUT = 2;
    @LayoutManagerType
    private int layoutManagerType = -1;
    private int currentScrollState;
    private int lastVisibleItemPosition;
    private IDataGetter dataGetter;

    public RecyclerViewScrollUpListener(IDataGetter dataGetter) {
        this.dataGetter = dataGetter;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        this.currentScrollState = newState;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        this.lastVisibleItemPosition = this.findLastVisibleItem(layoutManager);
        if (this.lastVisibleItemPosition < 0) {
            return;
        }
        int visibleItemCount = layoutManager.getChildCount();
        int totalItemCount = layoutManager.getItemCount();
        if (visibleItemCount > 0 && this.currentScrollState == 0 && this.lastVisibleItemPosition >= totalItemCount - 2 && this.dataGetter != null) {
            this.dataGetter.loadingData();
        }
    }

    public void setLayoutManagerType(@LayoutManagerType int layoutManagerType) {
        this.layoutManagerType = layoutManagerType;
    }

    int findLastVisibleItem(RecyclerView.LayoutManager layoutManager) {
        if (this.layoutManagerType < 0) {
            if (layoutManager instanceof GridLayoutManager) {
                this.setLayoutManagerType(1);
            } else if (layoutManager instanceof LinearLayoutManager) {
                this.setLayoutManagerType(0);
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.setLayoutManagerType(2);
            } else {
                throw new IllegalArgumentException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
            }
        }
        switch (this.layoutManagerType) {
            case 0: {
                return ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            }
            case 1: {
                return ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
            }
            case 2: {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                int[] lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                staggeredGridLayoutManager.findLastVisibleItemPositions(lastPositions);
                return this.findMax(lastPositions);
            }
        }
        return -1;
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static @interface LayoutManagerType {
    }
}

