/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.v7;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import com.x91tec.appshelf.R;
import com.x91tec.appshelf.ui.ViewUtils;
import com.x91tec.appshelf.v7.IDataGetter;
import com.x91tec.appshelf.v7.PageLoadingFooter;

public class SimpleLoadFooter
implements PageLoadingFooter {
    private View loadingLayout;
    private View mLoadingView;
    private View mNetworkErrorView;
    private View mTheEndView;
    private IDataGetter dataGetter;
    private int currentState;

    public SimpleLoadFooter(Context context, IDataGetter dataGetter) {
        this.loadingLayout = LayoutInflater.from((Context)context).inflate(R.layout.simple_list_loading_footer, null);
        this.loadingLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.dataGetter = dataGetter;
    }

    @Override
    public void onStartLoading() {
        this.onStateChanged(1);
        if (this.mTheEndView != null) {
            ViewUtils.checkAndSetViewVisibility(this.mTheEndView, 8);
        }
        if (this.mNetworkErrorView != null) {
            ViewUtils.checkAndSetViewVisibility(this.mNetworkErrorView, 8);
        }
        if (this.mLoadingView == null) {
            ViewStub viewStub = (ViewStub)this.loadingLayout.findViewById(R.id.loading_viewstub);
            this.mLoadingView = viewStub.inflate();
        }
        ViewUtils.checkAndSetViewVisibility(this.mLoadingView, 0);
    }

    @Override
    public void onLoadingComplete() {
        this.onStateChanged(0);
        if (this.mLoadingView != null) {
            ViewUtils.checkAndSetViewVisibility(this.mLoadingView, 8);
        }
        if (this.mTheEndView != null) {
            ViewUtils.checkAndSetViewVisibility(this.mTheEndView, 8);
        }
        if (this.mNetworkErrorView != null) {
            ViewUtils.checkAndSetViewVisibility(this.mNetworkErrorView, 8);
        }
    }

    @Override
    public void onReachToLastPage() {
        this.onStateChanged(3);
        if (this.mLoadingView != null) {
            ViewUtils.checkAndSetViewVisibility(this.mLoadingView, 8);
        }
        if (this.mNetworkErrorView != null) {
            ViewUtils.checkAndSetViewVisibility(this.mNetworkErrorView, 8);
        }
        if (this.mTheEndView == null) {
            ViewStub viewStub = (ViewStub)this.loadingLayout.findViewById(R.id.end_viewstub);
            this.mTheEndView = viewStub.inflate();
        }
        ViewUtils.checkAndSetViewVisibility(this.mTheEndView, 0);
    }

    @Override
    public void onLoadingError() {
        this.onStateChanged(2);
        if (this.mLoadingView != null) {
            ViewUtils.checkAndSetViewVisibility(this.mLoadingView, 8);
        }
        if (this.mTheEndView != null) {
            ViewUtils.checkAndSetViewVisibility(this.mTheEndView, 8);
        }
        if (this.mNetworkErrorView == null) {
            ViewStub viewStub = (ViewStub)this.loadingLayout.findViewById(R.id.network_error_viewstub);
            this.mNetworkErrorView = viewStub.inflate();
            this.mNetworkErrorView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (SimpleLoadFooter.this.dataGetter != null) {
                        SimpleLoadFooter.this.dataGetter.loadingData();
                    }
                }
            });
        }
        ViewUtils.checkAndSetViewVisibility(this.mNetworkErrorView, 0);
    }

    void onStateChanged(@PageLoadingFooter.LoadingState int newState) {
        this.currentState = newState;
    }

    @Override
    public int getLoadingState() {
        return this.currentState;
    }

    @Override
    public View getLoadingLayout() {
        return this.loadingLayout;
    }

    public void setLoadingLayoutParam(ViewGroup.LayoutParams param) {
        this.loadingLayout.setLayoutParams(param);
    }
}

