/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.v7;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.x91tec.appshelf.v7.DecorationFactory;

public class XDividerDecoration
extends RecyclerView.ItemDecoration {
    private final boolean paintBottomOfEnd;
    private final boolean isDrawablePaint;
    private DecorationFactory.ItemInfoProvider mItemInfoProvider;
    private DecorationFactory.MarginProvider mMarginProvider;
    private DecorationFactory.VisibilityProvider mVisibilityProvider;
    private DecorationFactory.DecorationPainter mDecorationPainter;
    private DecorationFactory.OrientationHandler mOrientationHandler;
    private DecorationFactory.SizeProvider mSizeProvider;

    protected XDividerDecoration(DecorationFactory.Builder builder) {
        this.mDecorationPainter = builder.mDecorationPainter;
        this.mVisibilityProvider = builder.mVisibilityProvider;
        this.paintBottomOfEnd = builder.paintBottomOfEnd;
        this.mMarginProvider = builder.mMarginProvider;
        this.mOrientationHandler = builder.mOrientationHandler;
        this.isDrawablePaint = builder.isDrawablePaint;
        this.mSizeProvider = builder.mSizeProvider;
        this.setItemInfoProvider(builder.gridLayout);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mDecorationPainter == null) {
            return;
        }
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (adapter == null) {
            return;
        }
        int itemCount = adapter.getItemCount();
        int lastDividerOffset = this.mItemInfoProvider.lastDividerOffset(parent);
        int validChildCount = parent.getChildCount();
        int lastChildPosition = -1;
        for (int i = 0; i < validChildCount; ++i) {
            View child = parent.getChildAt(i);
            int childPosition = parent.getChildAdapterPosition(child);
            if (childPosition < lastChildPosition) continue;
            lastChildPosition = childPosition;
            if (!this.paintBottomOfEnd && childPosition >= itemCount - lastDividerOffset || this.mItemInfoProvider.hasItemDrawnDivider(childPosition, parent)) continue;
            int groupIndex = this.mItemInfoProvider.itemIndex(childPosition, parent);
            if (this.mVisibilityProvider != null && this.mVisibilityProvider.shouldHideDivider(groupIndex, parent)) continue;
            int marginStart = this.mMarginProvider == null ? 0 : this.mMarginProvider.dividerStartMargin(groupIndex, parent);
            int marginEnd = this.mMarginProvider == null ? 0 : this.mMarginProvider.dividerEndMargin(groupIndex, parent);
            int dividerSize = this.mDecorationPainter.dividerSize(groupIndex, parent);
            Rect bounds = this.mOrientationHandler.dividerBoundsSetting(parent, child, marginStart, marginEnd, dividerSize, this.isDrawablePaint);
            this.mDecorationPainter.painting(parent, c, bounds, groupIndex);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int itemCount = parent.getAdapter().getItemCount();
        int lastDividerOffset = this.mItemInfoProvider.lastDividerOffset(parent);
        if (!this.paintBottomOfEnd && position >= itemCount - lastDividerOffset) {
            return;
        }
        int itemIndex = this.mItemInfoProvider.itemIndex(position, parent);
        int dividerSize = this.mDecorationPainter != null ? this.mDecorationPainter.dividerSize(itemIndex, parent) : (this.mSizeProvider != null ? this.mSizeProvider.dividerSize(itemIndex, parent) : 0);
        this.mOrientationHandler.setItemOffsets(outRect, itemIndex, dividerSize);
    }

    public void setItemInfoProvider(boolean gridLayout) {
        this.setItemInfoProvider(gridLayout ? new DecorationFactory.GridItemInfoProvider() : new DecorationFactory.LinerItemInfoProvider());
    }

    public void setItemInfoProvider(DecorationFactory.ItemInfoProvider provider) {
        this.mItemInfoProvider = provider;
    }
}

