/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.verify;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    public static final Pattern emailer = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    public static final String URL_REG_EXPRESSION = "^(https?://)?([a-zA-Z0-9_-]+\\.[a-zA-Z0-9_-]+)+(/*[A-Za-z0-9/\\-_&:?\\+=//.%]*)*";
    public static final Pattern PLATE_NUMBER_PATTERN = Pattern.compile("^[\u0391-\uffe5]{1}[a-zA-Z0-9]{6}$");
    public static final Pattern ID_CODE_PATTERN = Pattern.compile("^[a-zA-Z0-9]+$");
    public static final Pattern CODE_PATTERN = Pattern.compile("^[a-zA-Z0-9]+$");
    public static final Pattern PHONE_NUMBER_PATTERN = Pattern.compile("0\\d{2,3}-[0-9]+");
    public static final Pattern POST_CODE_PATTERN = Pattern.compile("\\d{6}");
    public static final Pattern AREA_PATTERN = Pattern.compile("\\d*.?\\d*");
    public static final Pattern ACCOUNT_NUMBER_PATTERN = Pattern.compile("\\d{16,21}");

    public static boolean isPlateNumber(String s) {
        Matcher m = PLATE_NUMBER_PATTERN.matcher(s);
        return m.matches();
    }

    public static boolean isIDCode(String s) {
        Matcher m = ID_CODE_PATTERN.matcher(s);
        return m.matches();
    }

    public static boolean isCode(String s) {
        Matcher m = CODE_PATTERN.matcher(s);
        return m.matches();
    }

    public static boolean isPhoneNumber(String s) {
        Matcher m = PHONE_NUMBER_PATTERN.matcher(s);
        return m.matches();
    }

    public static boolean isPostCode(String s) {
        Matcher m = POST_CODE_PATTERN.matcher(s);
        return m.matches();
    }

    public static boolean isArea(String s) {
        Matcher m = AREA_PATTERN.matcher(s);
        return m.matches();
    }

    public static boolean isAccountNumber(String s) {
        Matcher m = ACCOUNT_NUMBER_PATTERN.matcher(s);
        return m.matches();
    }

    public static boolean isEmail(String email) {
        if (email == null || email.trim().length() == 0) {
            return false;
        }
        return emailer.matcher(email).matches();
    }

    public static boolean isUrl(String s) {
        if (s == null) {
            return false;
        }
        return Pattern.matches(URL_REG_EXPRESSION, s);
    }

    public static Boolean isMobileNo(String phoneNumber) {
        Boolean isMobileNo = false;
        try {
            phoneNumber = phoneNumber.replaceAll(" ", "");
            Pattern p1 = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[^4,\\D]))\\d{8}$");
            Pattern p2 = Pattern.compile("^[569]\\D{7}");
            Pattern p3 = Pattern.compile("^6\\D{7}");
            Matcher m0 = p1.matcher(phoneNumber);
            Matcher m1 = p2.matcher(phoneNumber);
            Matcher m2 = p3.matcher(phoneNumber);
            isMobileNo = m0.matches() || m1.matches() || m2.matches();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isMobileNo;
    }
}

