/*
 * Decompiled with CFR 0.152.
 */
package com.x91tec.appshelf.web;

import android.annotation.SuppressLint;
import android.webkit.WebSettings;
import android.webkit.WebView;

public class WebViewManager {
    private WebView webView;
    private WebSettings webSettings;

    public WebViewManager(WebView webView) {
        this.webView = webView;
        this.webSettings = webView.getSettings();
        this.webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
    }

    public WebViewManager enableAdaptive() {
        this.webSettings.setUseWideViewPort(true);
        this.webSettings.setLoadWithOverviewMode(true);
        return this;
    }

    public WebViewManager disableAdaptive() {
        this.webSettings.setUseWideViewPort(true);
        this.webSettings.setLoadWithOverviewMode(true);
        return this;
    }

    public WebViewManager enableZoom() {
        this.webSettings.setSupportZoom(true);
        this.webSettings.setUseWideViewPort(true);
        this.webSettings.setBuiltInZoomControls(true);
        return this;
    }

    public WebViewManager disableZoom() {
        this.webSettings.setSupportZoom(false);
        this.webSettings.setUseWideViewPort(false);
        this.webSettings.setBuiltInZoomControls(false);
        return this;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public WebViewManager enableJavaScript() {
        this.webSettings.setJavaScriptEnabled(true);
        return this;
    }

    public WebViewManager disableJavaScript() {
        this.webSettings.setJavaScriptEnabled(false);
        return this;
    }

    public WebViewManager enableJavaScriptOpenWindowsAutomatically() {
        this.webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        return this;
    }

    public WebViewManager disableJavaScriptOpenWindowsAutomatically() {
        this.webSettings.setJavaScriptCanOpenWindowsAutomatically(false);
        return this;
    }

    public boolean goBack() {
        if (this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return false;
    }
}

