/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.openai.client.extension.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\"\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J!\u0010\u000b\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0082\u0004\u00a8\u0006\f"}, d2={"Lcom/aallam/openai/client/extension/internal/Cosine;", "", "()V", "distance", "", "vec1", "", "vec2", "norm", "vector", "similarity", "dot", "openai-client"})
@SourceDebugExtension(value={"SMAP\nCosineSimilarity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CosineSimilarity.kt\ncom/aallam/openai/client/extension/internal/Cosine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1789#2,3:35\n1789#2,3:38\n*S KotlinDebug\n*F\n+ 1 CosineSimilarity.kt\ncom/aallam/openai/client/extension/internal/Cosine\n*L\n25#1:35,3\n30#1:38,3\n*E\n"})
public final class Cosine {
    @NotNull
    public static final Cosine INSTANCE = new Cosine();

    private Cosine() {
    }

    public final double similarity(@NotNull List<Double> vec1, @NotNull List<Double> vec2) {
        Intrinsics.checkNotNullParameter(vec1, (String)"vec1");
        Intrinsics.checkNotNullParameter(vec2, (String)"vec2");
        if (Intrinsics.areEqual(vec1, vec2)) {
            return 1.0;
        }
        return this.dot(vec1, vec2) / (this.norm(vec1) * this.norm(vec2));
    }

    public final double distance(@NotNull List<Double> vec1, @NotNull List<Double> vec2) {
        Intrinsics.checkNotNullParameter(vec1, (String)"vec1");
        Intrinsics.checkNotNullParameter(vec2, (String)"vec2");
        return 1.0 - this.similarity(vec1, vec2);
    }

    /*
     * WARNING - void declaration
     */
    private final double dot(List<Double> $this$dot, List<Double> vector) {
        void $this$fold$iv;
        Iterable iterable = CollectionsKt.zip((Iterable)$this$dot, (Iterable)vector);
        double initial$iv = 0.0;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Pair pair = (Pair)element$iv;
            double acc = accumulator$iv;
            boolean bl = false;
            double i = ((Number)pair.component1()).doubleValue();
            double j = ((Number)pair.component2()).doubleValue();
            accumulator$iv = acc + i * j;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final double norm(List<Double> vector) {
        void $this$fold$iv;
        Iterable iterable = vector;
        double initial$iv = 0.0;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void cur;
            double d = ((Number)element$iv).doubleValue();
            double acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc + Math.pow((double)cur, 2);
        }
        double sum = accumulator$iv;
        return Math.sqrt(sum);
    }
}

