/**
 * The Abiquo Platform
 * Cloud management application for hybrid clouds
 * Copyright (C) 2008 - Abiquo Holdings S.L.
 *
 * This application is free software; you can redistribute it and/or
 * modify it under the terms of the GNU LESSER GENERAL PUBLIC
 * LICENSE as published by the Free Software Foundation under
 * version 3 of the License
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * LESSER GENERAL PUBLIC LICENSE v.3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.abiquo.event.adapter;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import com.abiquo.event.model.details.EventDetails;
import com.abiquo.event.model.details.MessageDetails;
import com.abiquo.event.model.interfaces.AbiquoKey;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;

/**
 * XmlAdapter implementation to generate the XML representation of a Map<String, String>. It is used
 * to un/marshal the constraints map of an hypervisor type.
 * 
 * @see HypervisorTypeDto#getConstraints()
 */
public class OptionalMapAdapter extends XmlAdapter<EventDetails, Optional< ? extends EventDetails>>
{

    @Override
    public Optional< ? extends EventDetails> unmarshal(final EventDetails details) throws Exception
    {
        return Optional.fromNullable(details);
    }

    @Override
    public EventDetails marshal(final Optional< ? extends EventDetails> optional) throws Exception
    {
        if (!optional.isPresent())
        {
            return new MessageDetails(ImmutableMap.<AbiquoKey, Object> of());
        }
        return optional.get();
    }

}
