/**
 * The Abiquo Platform
 * Cloud management application for hybrid clouds
 * Copyright (C) 2008 - Abiquo Holdings S.L.
 *
 * This application is free software; you can redistribute it and/or
 * modify it under the terms of the GNU LESSER GENERAL PUBLIC
 * LICENSE as published by the Free Software Foundation under
 * version 3 of the License
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * LESSER GENERAL PUBLIC LICENSE v.3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.abiquo.event.json.module;

import com.abiquo.event.model.details.EventDetails;
import com.abiquo.event.model.details.EventDetailsDeserializer;
import com.abiquo.event.model.details.EventDetailsSerializer;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;

/**
 * Module for custom {@link JsonSerializer} and {@link JsonDeserializer}.
 * 
 * @author <a href="mailto:serafin.sedano@abiquo.com">Serafin Sedano</a>
 */
public class AbiquoModule extends SimpleModule
{

    /**
     * 
     */
    private static final long serialVersionUID = -8391094596994578732L;

    public AbiquoModule()
    {
        super("Abiquo", new Version(0, 0, 1, "", "com.abiquo", "m"));
        addSerializer(EventDetails.class, new EventDetailsSerializer());
        addDeserializer(EventDetails.class, new EventDetailsDeserializer());
    }
}
