/**
 * The Abiquo Platform
 * Cloud management application for hybrid clouds
 * Copyright (C) 2008 - Abiquo Holdings S.L.
 *
 * This application is free software; you can redistribute it and/or
 * modify it under the terms of the GNU LESSER GENERAL PUBLIC
 * LICENSE as published by the Free Software Foundation under
 * version 3 of the License
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * LESSER GENERAL PUBLIC LICENSE v.3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.abiquo.event.model.details;

import static java.lang.String.valueOf;

import java.io.IOException;
import java.util.Collection;
import java.util.Map.Entry;

import com.abiquo.event.model.interfaces.AbiquoKey;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

public class EventDetailsSerializer extends JsonSerializer<EventDetails>
{

    @SuppressWarnings("unchecked")
    @Override
    public void serialize(final EventDetails value, final JsonGenerator jgen,
        final SerializerProvider provider) throws IOException, JsonProcessingException
    {
        jgen.writeStartObject();
        for (Entry<AbiquoKey, Object> e : value.entrySet())
        {
            if (e.getValue() instanceof Collection)
            {
                jgen.writeFieldName(e.getKey().name());
                jgen.writeStartArray();
                for (String el : (Collection<String>) e.getValue())
                {
                    jgen.writeString(el);
                }
                jgen.writeEndArray();
            }
            else
            {
                jgen.writeStringField(e.getKey().name(), valueOf(e.getValue()));
            }
        }

        jgen.writeEndObject();
    }
}
