/**
 * The Abiquo Platform
 * Cloud management application for hybrid clouds
 * Copyright (C) 2008 - Abiquo Holdings S.L.
 *
 * This application is free software; you can redistribute it and/or
 * modify it under the terms of the GNU LESSER GENERAL PUBLIC
 * LICENSE as published by the Free Software Foundation under
 * version 3 of the License
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * LESSER GENERAL PUBLIC LICENSE v.3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package com.abiquo.event.model.details;

import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.event.model.interfaces.AbiquoKey;
import com.google.common.collect.ImmutableMap;

/**
 * Decorator for map with the keys and values not recoverable externally after the event occurs.
 * 
 * @author <a href="mailto:sergi.castro@abiquo.com">Sergi Castro</a>
 */
@XmlRootElement
public class MessageDetails extends EventDetails
{

    /**
     * Creates the forwarding map using a copy of the given {@link ImmutableMap<AbiquoKey, String>}
     * map.
     * <p>
     * Must be a non-visible constructor to force the developer to use the {@link Builder}.
     * </p>
     * 
     * @param map the immutable map to create the event details
     */
    public MessageDetails(final ImmutableMap<AbiquoKey, Object> map)
    {
        super(map);
    }

    /**
     * Returns a builder instance for {@link MessageDetails}.
     * 
     * @return a builder instance for {@link MessageDetails}
     */
    @SuppressWarnings({"rawtypes", "unchecked"})
    public static Builder< ? , MessageDetails> builder()
    {
        return new Builder();
    }

    /**
     * Returns a builder instance for {@link MessageDetails} adding all entries from the given
     * {@link ImmutableMap<AbiquoKey, String>}.
     * 
     * @param map the given {@link ImmutableMap<AbiquoKey, String>} where obtain the entries
     * @return a builder instance for {@link MessageDetails}
     */
    @SuppressWarnings({"rawtypes", "unchecked"})
    public static Builder< ? , MessageDetails> builder(
        final ImmutableMap< ? extends AbiquoKey, String> map)
    {
        return new Builder(map);
    }

    /**
     * Builder helper for {@link MessageDetails}.
     * 
     * @param <B> Any instance type of the hierarchy of {@link Builder}, required to allow the
     *            hierarchy in the builders.
     * @param <E> Any class extending of {@link MessageDetails}
     */
    public static class Builder<B extends Builder<B, E>, E extends MessageDetails>
        extends EventDetails.Builder<B, E>
    {

        /**
         * Initializes the builder.
         */
        public Builder()
        {
            super();
        }

        /**
         * Initializes the builder adding all entries from the given {@link ImmutableMap<AbiquoKey,
         * String>}.
         * 
         * @param map the given {@link ImmutableMap<AbiquoKey, String>} where obtain the entries
         */
        public Builder(final ImmutableMap<AbiquoKey, String> map)
        {
            super();
            this.messageArgs(map);
        }

        /**
         * @see com.abiquo.model.details.EventDetails.Builder#self()
         */
        @SuppressWarnings("unchecked")
        @Override
        protected B self()
        {
            return (B) this;
        }

        /**
         * @see com.abiquo.model.details.EventDetails.Builder#build()
         */
        @SuppressWarnings("unchecked")
        @Override
        public E build()
        {
            return (E) new MessageDetails(this.mapBuilder.build());
        }

    }
}
