/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.event.model;

import com.abiquo.event.adapter.OptionalMapAdapter;
import com.abiquo.event.model.EventAdapter;
import com.abiquo.event.model.details.EventDetails;
import com.abiquo.event.model.enumerations.EntityAction;
import com.abiquo.event.model.enumerations.Severity;
import com.abiquo.event.model.enumerations.Source;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.io.Serializable;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="event")
@XmlType(propOrder={"timestamp", "user", "enterprise", "severity", "source", "action", "type", "entityIdentifier", "details"})
public class Event
implements Serializable {
    private static final long serialVersionUID = -5535795080620821917L;
    private long timestamp;
    private String timezone;
    private String user;
    private String enterprise;
    private Severity severity;
    private Source source;
    private String action;
    private String type;
    private Optional<String> entityIdentifier;
    private Optional<? extends EventDetails> details;

    private Event(String type, String action, String user, String enterprise, Source source, Severity severity) {
        this.timestamp = System.currentTimeMillis();
        this.timezone = TimeZone.getDefault().getID();
        this.type = type;
        this.action = action;
        this.source = source;
        this.severity = severity;
        this.user = user;
        this.enterprise = enterprise;
    }

    @Deprecated
    public Event() {
        this.timestamp = 0L;
        this.timezone = "";
        this.type = "";
        this.action = "";
        this.source = null;
        this.severity = null;
        this.user = "";
        this.enterprise = "";
    }

    @XmlElement(name="timestamp")
    @NotNull
    public long getTimestamp() {
        return this.timestamp;
    }

    @XmlElement(name="timezone")
    @NotNull
    public String getTimezone() {
        return this.timezone;
    }

    @XmlElement(name="user")
    @NotNull
    public String getUser() {
        return this.user;
    }

    @XmlElement(name="severity")
    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    @XmlElement(name="enterprise")
    @NotNull
    public String getEnterprise() {
        return this.enterprise;
    }

    @XmlElement(name="source")
    @NotNull
    public Source getSource() {
        return this.source;
    }

    @XmlElement(name="action")
    @NotNull
    public String getAction() {
        return this.action;
    }

    @XmlElement(name="type")
    @NotNull
    public String getType() {
        return this.type;
    }

    @XmlJavaTypeAdapter(value=EventAdapter.OptionalStringAdapter.class)
    public Optional<String> getEntityIdentifier() {
        return this.entityIdentifier;
    }

    @XmlAnyElement
    @XmlJavaTypeAdapter(value=OptionalMapAdapter.class)
    public Optional<? extends EventDetails> getDetails() {
        return this.details;
    }

    private void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    private void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    private void setUser(String user) {
        this.user = user;
    }

    private void setEnterprise(String enterprise) {
        this.enterprise = enterprise;
    }

    private void setSeverity(Severity severity) {
        this.severity = severity;
    }

    private void setSource(Source source) {
        this.source = source;
    }

    private void setAction(String action) {
        this.action = action;
    }

    private void setType(String type) {
        this.type = type;
    }

    private void setDetails(Optional<? extends EventDetails> details) {
        this.details = details;
    }

    public static EventBuilder builder(EntityAction.Action<?> entityAction, String user, String enterprise, Source source, Severity severity) {
        return new EventBuilder(entityAction, user, enterprise, source, severity);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + (this.entityIdentifier == null ? 0 : this.entityIdentifier.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.details == null ? other.details != null : !this.details.equals(other.details)) {
            return false;
        }
        if (this.entityIdentifier == null ? other.entityIdentifier != null : !this.entityIdentifier.equals(other.entityIdentifier)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (this.source != other.source) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("severity", (Object)this.severity).add("type", (Object)this.type).add("action", (Object)this.action).add("timestamp", this.timestamp).add("user", (Object)this.user).add("enterprise", (Object)this.enterprise).add("entityIdentifier", this.entityIdentifier.orNull()).add("source", (Object)this.source).toString();
    }

    public static class EventBuilder {
        private Event event;

        private EventBuilder(EntityAction.Action<?> entityAction, String user, String enterprise, Source source, Severity severity) {
            String type = entityAction.entity();
            String action = entityAction.action();
            this.event = new Event(type, action, user, enterprise, source, severity);
            this.entityIdentifier(null);
            this.details(null);
        }

        public Event build() {
            return this.event;
        }

        public EventBuilder entityIdentifier(String value) {
            this.event.entityIdentifier = Optional.fromNullable((Object)value);
            return this;
        }

        public <E extends EventDetails> EventBuilder details(E value) {
            this.event.details = Optional.fromNullable(value);
            return this;
        }
    }
}

